/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.gridtable.CuboidToGridTableMapping;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.lookup.LookupStringTable;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;

public class CubeTupleConverter {
    final CubeSegment cubeSeg;
    final Cuboid cuboid;
    final TupleInfo tupleInfo;
    final List<IDerivedColumnFiller> derivedColFillers;
    final int[] gtColIdx;
    final int[] tupleIdx;
    final Object[] gtValues;
    final MeasureType<?>[] measureTypes;
    final List<MeasureType.IAdvMeasureFiller> advMeasureFillers;
    final List<Integer> advMeasureIndexInGTValues;
    final int nSelectedDims;

    public CubeTupleConverter(CubeSegment cubeSeg, Cuboid cuboid, Set<TblColRef> selectedDimensions, Set<FunctionDesc> selectedMetrics, TupleInfo returnTupleInfo) {
        int i;
        this.cubeSeg = cubeSeg;
        this.cuboid = cuboid;
        this.tupleInfo = returnTupleInfo;
        this.derivedColFillers = Lists.newArrayList();
        List<TblColRef> cuboidDims = cuboid.getColumns();
        CuboidToGridTableMapping mapping = cuboid.getCuboidToGridTableMapping();
        this.nSelectedDims = selectedDimensions.size();
        this.gtColIdx = new int[selectedDimensions.size() + selectedMetrics.size()];
        this.tupleIdx = new int[selectedDimensions.size() + selectedMetrics.size()];
        this.gtValues = new Object[selectedDimensions.size() + selectedMetrics.size()];
        this.measureTypes = new MeasureType[selectedDimensions.size() + selectedMetrics.size()];
        this.advMeasureFillers = Lists.newArrayListWithCapacity((int)1);
        this.advMeasureIndexInGTValues = Lists.newArrayListWithCapacity((int)1);
        int iii = 0;
        for (TblColRef dim : selectedDimensions) {
            this.gtColIdx[iii] = i = mapping.getIndexOf(dim);
            this.tupleIdx[iii] = this.tupleInfo.hasColumn(dim) ? this.tupleInfo.getColumnIndex(dim) : -1;
            ++iii;
        }
        for (FunctionDesc metric : selectedMetrics) {
            TblColRef col;
            String rewriteFieldName;
            this.gtColIdx[iii] = i = mapping.getIndexOf(metric);
            this.tupleIdx[iii] = metric.needRewrite() ? (this.tupleInfo.hasField(rewriteFieldName = metric.getRewriteFieldName()) ? this.tupleInfo.getFieldIndex(rewriteFieldName) : -1) : (this.tupleInfo.hasColumn(col = metric.getParameter().getColRefs().get(0)) ? this.tupleInfo.getColumnIndex(col) : -1);
            MeasureType<?> measureType = metric.getMeasureType();
            if (measureType.needAdvancedTupleFilling()) {
                Map<TblColRef, Dictionary<String>> dictionaryMap = this.buildDictionaryMap(measureType.getColumnsNeedDictionary(metric));
                this.advMeasureFillers.add(measureType.getAdvancedTupleFiller(metric, returnTupleInfo, dictionaryMap));
                this.advMeasureIndexInGTValues.add(iii);
            } else {
                this.measureTypes[iii] = measureType;
            }
            ++iii;
        }
        Map<Array<TblColRef>, List<CubeDesc.DeriveInfo>> hostToDerivedInfo = cuboid.getCubeDesc().getHostToDerivedInfo(cuboidDims, null);
        for (Map.Entry<Array<TblColRef>, List<CubeDesc.DeriveInfo>> entry : hostToDerivedInfo.entrySet()) {
            TblColRef[] hostCols = (TblColRef[])entry.getKey().data;
            for (CubeDesc.DeriveInfo deriveInfo : entry.getValue()) {
                IDerivedColumnFiller filler = this.newDerivedColumnFiller(hostCols, deriveInfo);
                if (filler == null) continue;
                this.derivedColFillers.add(filler);
            }
        }
    }

    private Map<TblColRef, Dictionary<String>> buildDictionaryMap(List<TblColRef> columnsNeedDictionary) {
        HashMap result = Maps.newHashMap();
        for (TblColRef col : columnsNeedDictionary) {
            result.put(col, this.cubeSeg.getDictionary(col));
        }
        return result;
    }

    public List<MeasureType.IAdvMeasureFiller> translateResult(GTRecord record, Tuple tuple) {
        int ti;
        int i;
        record.getValues(this.gtColIdx, this.gtValues);
        for (i = 0; i < this.nSelectedDims; ++i) {
            ti = this.tupleIdx[i];
            if (ti < 0) continue;
            tuple.setDimensionValue(ti, CubeTupleConverter.toString(this.gtValues[i]));
        }
        for (i = this.nSelectedDims; i < this.gtColIdx.length; ++i) {
            ti = this.tupleIdx[i];
            if (ti < 0 || this.measureTypes[i] == null) continue;
            this.measureTypes[i].fillTupleSimply(tuple, ti, this.gtValues[i]);
        }
        for (IDerivedColumnFiller filler : this.derivedColFillers) {
            filler.fillDerivedColumns(this.gtValues, tuple);
        }
        if (this.advMeasureFillers.isEmpty()) {
            return null;
        }
        for (int i2 = 0; i2 < this.advMeasureFillers.size(); ++i2) {
            Object measureValue = this.gtValues[this.advMeasureIndexInGTValues.get(i2)];
            this.advMeasureFillers.get(i2).reload(measureValue);
        }
        return this.advMeasureFillers;
    }

    private IDerivedColumnFiller newDerivedColumnFiller(TblColRef[] hostCols, final CubeDesc.DeriveInfo deriveInfo) {
        boolean allHostsPresent = true;
        final int[] hostTmpIdx = new int[hostCols.length];
        for (int i = 0; i < hostCols.length; ++i) {
            hostTmpIdx[i] = this.indexOnTheGTValues(hostCols[i]);
            allHostsPresent = allHostsPresent && hostTmpIdx[i] >= 0;
        }
        boolean needCopyDerived = false;
        final int[] derivedTupleIdx = new int[deriveInfo.columns.length];
        for (int i = 0; i < deriveInfo.columns.length; ++i) {
            TblColRef col = deriveInfo.columns[i];
            derivedTupleIdx[i] = this.tupleInfo.hasColumn(col) ? this.tupleInfo.getColumnIndex(col) : -1;
            needCopyDerived = needCopyDerived || derivedTupleIdx[i] >= 0;
        }
        if (!(allHostsPresent && needCopyDerived)) {
            return null;
        }
        switch (deriveInfo.type) {
            case LOOKUP: {
                return new IDerivedColumnFiller(){
                    CubeManager cubeMgr;
                    LookupStringTable lookupTable;
                    int[] derivedColIdx;
                    Array<String> lookupKey;
                    {
                        this.cubeMgr = CubeManager.getInstance(CubeTupleConverter.this.cubeSeg.getCubeInstance().getConfig());
                        this.lookupTable = this.cubeMgr.getLookupTable(CubeTupleConverter.this.cubeSeg, deriveInfo.dimension);
                        this.derivedColIdx = this.initDerivedColIdx();
                        this.lookupKey = new Array<String>(new String[hostTmpIdx.length]);
                    }

                    private int[] initDerivedColIdx() {
                        int[] idx = new int[deriveInfo.columns.length];
                        for (int i = 0; i < idx.length; ++i) {
                            idx[i] = deriveInfo.columns[i].getColumnDesc().getZeroBasedIndex();
                        }
                        return idx;
                    }

                    @Override
                    public void fillDerivedColumns(Object[] gtValues, Tuple tuple) {
                        for (int i = 0; i < hostTmpIdx.length; ++i) {
                            ((String[])this.lookupKey.data)[i] = CubeTupleConverter.toString(gtValues[hostTmpIdx[i]]);
                        }
                        String[] lookupRow = (String[])this.lookupTable.getRow(this.lookupKey);
                        if (lookupRow != null) {
                            for (int i = 0; i < derivedTupleIdx.length; ++i) {
                                if (derivedTupleIdx[i] < 0) continue;
                                String value = lookupRow[this.derivedColIdx[i]];
                                tuple.setDimensionValue(derivedTupleIdx[i], value);
                            }
                        } else {
                            for (int i = 0; i < derivedTupleIdx.length; ++i) {
                                if (derivedTupleIdx[i] < 0) continue;
                                tuple.setDimensionValue(derivedTupleIdx[i], null);
                            }
                        }
                    }
                };
            }
            case PK_FK: {
                return new IDerivedColumnFiller(){

                    @Override
                    public void fillDerivedColumns(Object[] gtValues, Tuple tuple) {
                        tuple.setDimensionValue(derivedTupleIdx[0], CubeTupleConverter.toString(gtValues[hostTmpIdx[0]]));
                    }
                };
            }
        }
        throw new IllegalArgumentException();
    }

    private int indexOnTheGTValues(TblColRef col) {
        List<TblColRef> cuboidDims = this.cuboid.getColumns();
        int cuboidIdx = cuboidDims.indexOf(col);
        for (int i = 0; i < this.gtColIdx.length; ++i) {
            if (this.gtColIdx[i] != cuboidIdx) continue;
            return i;
        }
        return -1;
    }

    private static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    private static interface IDerivedColumnFiller {
        public void fillDerivedColumns(Object[] var1, Tuple var2);
    }
}

