/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.lookup.LookupStringTable;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.storage.IStorageQuery;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.hbase.cube.v2.CubeSegmentScanner;
import org.apache.kylin.storage.hbase.cube.v2.SequentialCubeTupleIterator;
import org.apache.kylin.storage.translate.DerivedFilterTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeStorageQuery
implements IStorageQuery {
    private static final Logger logger = LoggerFactory.getLogger(CubeStorageQuery.class);
    private final CubeInstance cubeInstance;
    private final CubeDesc cubeDesc;

    public CubeStorageQuery(CubeInstance cube) {
        this.cubeInstance = cube;
        this.cubeDesc = cube.getDescriptor();
    }

    @Override
    public ITupleIterator search(StorageContext context, SQLDigest sqlDigest, TupleInfo returnTupleInfo) {
        this.notifyBeforeStorageQuery(sqlDigest);
        Collection<TblColRef> groups = sqlDigest.groupbyColumns;
        TupleFilter filter = sqlDigest.filter;
        LinkedHashSet<TblColRef> dimensions = new LinkedHashSet<TblColRef>();
        LinkedHashSet<FunctionDesc> metrics = new LinkedHashSet<FunctionDesc>();
        this.buildDimensionsAndMetrics(sqlDigest, dimensions, metrics);
        HashSet otherDims = Sets.newHashSet(dimensions);
        otherDims.removeAll(groups);
        HashSet derivedPostAggregation = Sets.newHashSet();
        Set<TblColRef> groupsD = this.expandDerived(groups, derivedPostAggregation);
        Set<TblColRef> otherDimsD = this.expandDerived(otherDims, derivedPostAggregation);
        otherDimsD.removeAll(groupsD);
        LinkedHashSet<TblColRef> dimensionsD = new LinkedHashSet<TblColRef>();
        dimensionsD.addAll(groupsD);
        dimensionsD.addAll(otherDimsD);
        Cuboid cuboid = Cuboid.identifyCuboid(this.cubeDesc, dimensionsD, metrics);
        context.setCuboid(cuboid);
        Set<TblColRef> singleValuesD = this.findSingleValueColumns(filter);
        boolean isExactAggregation = this.isExactAggregation(cuboid, groups, otherDimsD, singleValuesD, derivedPostAggregation);
        context.setExactAggregation(isExactAggregation);
        TupleFilter filterD = this.translateDerived(filter, groupsD);
        this.setThreshold(dimensionsD, metrics, context);
        this.setLimit(filter, context);
        ArrayList scanners = Lists.newArrayList();
        for (CubeSegment cubeSeg : this.cubeInstance.getSegments(SegmentStatusEnum.READY)) {
            if (cubeSeg.getInputRecords() == 0L) {
                logger.info("Skip cube segment {} because its input record is 0", (Object)cubeSeg);
                continue;
            }
            CubeSegmentScanner scanner = new CubeSegmentScanner(cubeSeg, cuboid, dimensionsD, groupsD, metrics, filterD, !isExactAggregation);
            scanners.add(scanner);
        }
        if (scanners.isEmpty()) {
            return ITupleIterator.EMPTY_TUPLE_ITERATOR;
        }
        return new SequentialCubeTupleIterator(scanners, cuboid, dimensionsD, metrics, returnTupleInfo, context);
    }

    private void buildDimensionsAndMetrics(SQLDigest sqlDigest, Collection<TblColRef> dimensions, Collection<FunctionDesc> metrics) {
        for (FunctionDesc func : sqlDigest.aggregations) {
            if (func.isDimensionAsMetric()) continue;
            metrics.add(this.findAggrFuncFromCubeDesc(func));
        }
        for (TblColRef column : sqlDigest.allColumns) {
            if (sqlDigest.metricColumns.contains(column) && !sqlDigest.groupbyColumns.contains(column) && !sqlDigest.filterColumns.contains(column)) continue;
            dimensions.add(column);
        }
    }

    private FunctionDesc findAggrFuncFromCubeDesc(FunctionDesc aggrFunc) {
        for (MeasureDesc measure : this.cubeDesc.getMeasures()) {
            if (!measure.getFunction().equals(aggrFunc)) continue;
            return measure.getFunction();
        }
        return aggrFunc;
    }

    private Set<TblColRef> expandDerived(Collection<TblColRef> cols, Set<TblColRef> derivedPostAggregation) {
        HashSet expanded = Sets.newHashSet();
        for (TblColRef col : cols) {
            if (this.cubeDesc.hasHostColumn(col)) {
                CubeDesc.DeriveInfo hostInfo = this.cubeDesc.getHostInfo(col);
                for (TblColRef hostCol : hostInfo.columns) {
                    expanded.add(hostCol);
                    if (hostInfo.isOneToOne) continue;
                    derivedPostAggregation.add(hostCol);
                }
                continue;
            }
            expanded.add(col);
        }
        return expanded;
    }

    private Set<TblColRef> findSingleValueColumns(TupleFilter filter) {
        Collection<TupleFilter> toCheck;
        if (filter instanceof CompareTupleFilter) {
            toCheck = Collections.singleton(filter);
        } else if (filter instanceof LogicalTupleFilter && filter.getOperator() == TupleFilter.FilterOperatorEnum.AND) {
            toCheck = filter.getChildren();
        } else {
            return Collections.EMPTY_SET;
        }
        HashSet result = Sets.newHashSet();
        for (TupleFilter f : toCheck) {
            CompareTupleFilter compFilter;
            if (!(f instanceof CompareTupleFilter) || (compFilter = (CompareTupleFilter)f).getOperator() != TupleFilter.FilterOperatorEnum.EQ || compFilter.getValues().size() != 1 || compFilter.getColumn() == null) continue;
            result.add(compFilter.getColumn());
        }
        HashSet resultD = Sets.newHashSet();
        for (TblColRef col : result) {
            if (this.cubeDesc.isExtendedColumn(col)) {
                throw new CubeDesc.CannotFilterExtendedColumnException(col);
            }
            if (this.cubeDesc.isDerived(col)) {
                CubeDesc.DeriveInfo hostInfo = this.cubeDesc.getHostInfo(col);
                if (!hostInfo.isOneToOne) continue;
                for (TblColRef hostCol : hostInfo.columns) {
                    resultD.add(hostCol);
                }
                continue;
            }
            resultD.add(col);
        }
        return resultD;
    }

    private boolean isExactAggregation(Cuboid cuboid, Collection<TblColRef> groups, Set<TblColRef> othersD, Set<TblColRef> singleValuesD, Set<TblColRef> derivedPostAggregation) {
        boolean exact = true;
        if (cuboid.requirePostAggregation()) {
            exact = false;
            logger.info("exactAggregation is false because cuboid " + cuboid.getInputID() + "=> " + cuboid.getId());
        }
        if (!groups.containsAll(derivedPostAggregation)) {
            exact = false;
            logger.info("exactAggregation is false because derived column require post aggregation: " + derivedPostAggregation);
        }
        if (!singleValuesD.containsAll(othersD)) {
            exact = false;
            logger.info("exactAggregation is false because some column not on group by: " + othersD + " (single value column: " + singleValuesD + ")");
        }
        if (exact) {
            logger.info("exactAggregation is true");
        }
        return exact;
    }

    private TupleFilter translateDerived(TupleFilter filter, Set<TblColRef> collector) {
        if (filter == null) {
            return filter;
        }
        if (filter instanceof CompareTupleFilter) {
            return this.translateDerivedInCompare((CompareTupleFilter)filter, collector);
        }
        List<? extends TupleFilter> children = filter.getChildren();
        ArrayList newChildren = Lists.newArrayListWithCapacity((int)children.size());
        boolean modified = false;
        for (TupleFilter tupleFilter : children) {
            TupleFilter translated = this.translateDerived(tupleFilter, collector);
            newChildren.add(translated);
            if (tupleFilter == translated) continue;
            modified = true;
        }
        if (modified) {
            filter = this.replaceChildren(filter, newChildren);
        }
        return filter;
    }

    private TupleFilter replaceChildren(TupleFilter filter, List<TupleFilter> newChildren) {
        if (filter instanceof LogicalTupleFilter) {
            LogicalTupleFilter r = new LogicalTupleFilter(filter.getOperator());
            r.addChildren(newChildren);
            return r;
        }
        throw new IllegalStateException("Cannot replaceChildren on " + filter);
    }

    private TupleFilter translateDerivedInCompare(CompareTupleFilter compf, Set<TblColRef> collector) {
        if (compf.getColumn() == null || compf.getValues().isEmpty()) {
            return compf;
        }
        TblColRef derived = compf.getColumn();
        if (this.cubeDesc.isExtendedColumn(derived)) {
            throw new CubeDesc.CannotFilterExtendedColumnException(derived);
        }
        if (!this.cubeDesc.isDerived(derived)) {
            return compf;
        }
        CubeDesc.DeriveInfo hostInfo = this.cubeDesc.getHostInfo(derived);
        CubeManager cubeMgr = CubeManager.getInstance(this.cubeInstance.getConfig());
        CubeSegment seg = this.cubeInstance.getLatestReadySegment();
        LookupStringTable lookup = cubeMgr.getLookupTable(seg, hostInfo.dimension);
        Pair<TupleFilter, Boolean> translated = DerivedFilterTranslator.translate(lookup, hostInfo, compf);
        TupleFilter translatedFilter = translated.getFirst();
        boolean loosened = translated.getSecond();
        if (loosened) {
            this.collectColumnsRecursively(translatedFilter, collector);
        }
        return translatedFilter;
    }

    private void collectColumnsRecursively(TupleFilter filter, Set<TblColRef> collector) {
        if (filter == null) {
            return;
        }
        if (filter instanceof ColumnTupleFilter) {
            this.collectColumns(((ColumnTupleFilter)filter).getColumn(), collector);
        }
        for (TupleFilter tupleFilter : filter.getChildren()) {
            this.collectColumnsRecursively(tupleFilter, collector);
        }
    }

    private void collectColumns(TblColRef col, Set<TblColRef> collector) {
        if (this.cubeDesc.isExtendedColumn(col)) {
            throw new CubeDesc.CannotFilterExtendedColumnException(col);
        }
        if (this.cubeDesc.isDerived(col)) {
            CubeDesc.DeriveInfo hostInfo = this.cubeDesc.getHostInfo(col);
            for (TblColRef h : hostInfo.columns) {
                collector.add(h);
            }
        } else {
            collector.add(col);
        }
    }

    private void setThreshold(Collection<TblColRef> dimensions, Collection<FunctionDesc> metrics, StorageContext context) {
        boolean hasMemHungryMeasure = false;
        for (FunctionDesc func : metrics) {
            hasMemHungryMeasure |= func.getMeasureType().isMemoryHungry();
        }
        if (!hasMemHungryMeasure) {
            return;
        }
        int rowSizeEst = dimensions.size() * 3;
        for (FunctionDesc func : metrics) {
            rowSizeEst += func.getReturnDataType().getStorageBytesEstimate();
        }
        long rowEst = this.cubeInstance.getConfig().getQueryMemBudget() / (long)rowSizeEst;
        if (rowEst > 0L) {
            logger.info("Memory budget is set to: " + rowEst);
            context.setThreshold((int)rowEst);
        } else {
            logger.info("Memory budget is not set.");
        }
    }

    private void setLimit(TupleFilter filter, StorageContext context) {
        boolean goodSort;
        boolean goodAggr = context.isExactAggregation();
        boolean goodFilter = filter == null || TupleFilter.isEvaluableRecursively(filter) && context.isCoprocessorEnabled();
        boolean bl = goodSort = !context.hasSort();
        if (goodAggr && goodFilter && goodSort) {
            logger.info("Enable limit " + context.getLimit());
            context.enableLimit();
        }
    }

    private void notifyBeforeStorageQuery(SQLDigest sqlDigest) {
        for (MeasureDesc measure : this.cubeDesc.getMeasures()) {
            MeasureType<?> measureType = measure.getFunction().getMeasureType();
            measureType.adjustSqlDigest(measure, sqlDigest);
        }
    }
}

