/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.dict.BuildInFunctionTransformer;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRangePlanner;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.ScannerWorker;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeSegmentScanner
implements IGTScanner {
    private static final Logger logger = LoggerFactory.getLogger(CubeSegmentScanner.class);
    final CubeSegment cubeSeg;
    final ScannerWorker scanner;
    final Cuboid cuboid;
    final GTScanRequest scanRequest;

    public CubeSegmentScanner(CubeSegment cubeSeg, Cuboid cuboid, Set<TblColRef> dimensions, Set<TblColRef> groups, Collection<FunctionDesc> metrics, TupleFilter filter, boolean allowPreAggregate) {
        GTScanRangePlanner scanRangePlanner;
        this.cuboid = cuboid;
        this.cubeSeg = cubeSeg;
        BuildInFunctionTransformer translator = new BuildInFunctionTransformer(cubeSeg.getDimensionEncodingMap());
        filter = translator.transform(filter);
        String plannerName = KylinConfig.getInstanceFromEnv().getQueryStorageVisitPlanner();
        try {
            scanRangePlanner = (GTScanRangePlanner)Class.forName(plannerName).getConstructor(CubeSegment.class, Cuboid.class, TupleFilter.class, Set.class, Set.class, Collection.class).newInstance(cubeSeg, cuboid, filter, dimensions, groups, metrics);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.scanRequest = scanRangePlanner.planScanRequest(allowPreAggregate);
        this.scanner = new ScannerWorker(cubeSeg, cuboid, this.scanRequest);
    }

    @Override
    public Iterator<GTRecord> iterator() {
        return this.scanner.iterator();
    }

    @Override
    public void close() throws IOException {
        this.scanner.close();
    }

    @Override
    public GTInfo getInfo() {
        return this.scanRequest == null ? null : this.scanRequest.getInfo();
    }

    @Override
    public int getScannedRowCount() {
        return this.scanner.getScannedRowCount();
    }
}

