/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase;

import com.google.common.base.Preconditions;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.engine.mr.IMROutput;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.storage.IStorage;
import org.apache.kylin.storage.IStorageQuery;
import org.apache.kylin.storage.hbase.steps.HBaseMROutput;
import org.apache.kylin.storage.hbase.steps.HBaseMROutput2Transition;

public class HBaseStorage
implements IStorage {
    public static final String v2CubeStorageQuery = "org.apache.kylin.storage.hbase.cube.v2.CubeStorageQuery";
    public static final String v1CubeStorageQuery = "org.apache.kylin.storage.hbase.cube.v1.CubeStorageQuery";
    public static String overwriteStorageQuery = null;
    private static final String defaultIIStorageQuery = "org.apache.kylin.storage.hbase.ii.InvertedIndexStorageQuery";

    @Override
    public IStorageQuery createQuery(IRealization realization) {
        if (realization.getType() == RealizationType.INVERTED_INDEX) {
            IStorageQuery ret;
            try {
                ret = (IStorageQuery)Class.forName(defaultIIStorageQuery).getConstructor(IIInstance.class).newInstance((IIInstance)realization);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize storage query for org.apache.kylin.storage.hbase.ii.InvertedIndexStorageQuery", e);
            }
            return ret;
        }
        if (realization.getType() == RealizationType.CUBE) {
            IStorageQuery ret;
            CubeInstance cubeInstance = (CubeInstance)realization;
            String cubeStorageQuery = cubeInstance.getStorageType() == 0 ? v1CubeStorageQuery : (overwriteStorageQuery != null ? overwriteStorageQuery : ("v1".equalsIgnoreCase(BackdoorToggles.getHbaseCubeQueryVersion()) ? v1CubeStorageQuery : v2CubeStorageQuery));
            try {
                ret = (IStorageQuery)Class.forName(cubeStorageQuery).getConstructor(CubeInstance.class).newInstance((CubeInstance)realization);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize storage query for " + cubeStorageQuery, e);
            }
            return ret;
        }
        throw new IllegalArgumentException("Unknown realization type " + (Object)((Object)realization.getType()));
    }

    private static TblColRef getPartitionCol(IRealization realization) {
        String modelName = realization.getModelName();
        DataModelDesc dataModelDesc = MetadataManager.getInstance(KylinConfig.getInstanceFromEnv()).getDataModelDesc(modelName);
        PartitionDesc partitionDesc = dataModelDesc.getPartitionDesc();
        Preconditions.checkArgument((partitionDesc != null ? 1 : 0) != 0, (Object)("PartitionDesc for " + realization + " is null!"));
        TblColRef partitionColRef = partitionDesc.getPartitionDateColumnRef();
        Preconditions.checkArgument((partitionColRef != null ? 1 : 0) != 0, (Object)("getPartitionDateColumnRef for " + realization + " is null"));
        return partitionColRef;
    }

    @Override
    public <I> I adaptToBuildEngine(Class<I> engineInterface) {
        if (engineInterface == IMROutput.class) {
            return (I)new HBaseMROutput();
        }
        if (engineInterface == IMROutput2.class) {
            return (I)new HBaseMROutput2Transition();
        }
        throw new RuntimeException("Cannot adapt to " + engineInterface);
    }
}

