/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.cache;

import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;

public class TsConditionExtractor {
    public static Range<Long> extractTsCondition(TblColRef tsColRef, TupleFilter rootFilter) {
        return TsConditionExtractor.extractTsConditionInternal(rootFilter, tsColRef);
    }

    private static Range<Long> extractTsConditionInternal(TupleFilter filter, TblColRef colRef) {
        if (filter == null) {
            return Ranges.all();
        }
        if (filter instanceof LogicalTupleFilter) {
            if (filter.getOperator() == TupleFilter.FilterOperatorEnum.AND) {
                Range ret = Ranges.all();
                for (TupleFilter tupleFilter : filter.getChildren()) {
                    Range<Long> childRange = TsConditionExtractor.extractTsConditionInternal(tupleFilter, colRef);
                    if (childRange != null) {
                        if (ret.isConnected(childRange) && !ret.intersection(childRange).isEmpty()) {
                            ret = ret.intersection(childRange);
                            continue;
                        }
                        return null;
                    }
                    return null;
                }
                return ret.isEmpty() ? null : ret;
            }
            return Ranges.all();
        }
        if (filter instanceof CompareTupleFilter) {
            CompareTupleFilter compareTupleFilter = (CompareTupleFilter)filter;
            if (compareTupleFilter.getColumn() == null) {
                return Ranges.all();
            }
            if (compareTupleFilter.getColumn().equals(colRef)) {
                Object firstValue = compareTupleFilter.getFirstValue();
                switch (compareTupleFilter.getOperator()) {
                    case EQ: {
                        long l = DateFormat.stringToMillis((String)firstValue);
                        return Ranges.closed((Comparable)Long.valueOf(l), (Comparable)Long.valueOf(l));
                    }
                    case LT: {
                        long l = DateFormat.stringToMillis((String)firstValue);
                        return Ranges.lessThan((Comparable)Long.valueOf(l));
                    }
                    case LTE: {
                        long l = DateFormat.stringToMillis((String)firstValue);
                        return Ranges.atMost((Comparable)Long.valueOf(l));
                    }
                    case GT: {
                        long l = DateFormat.stringToMillis((String)firstValue);
                        return Ranges.greaterThan((Comparable)Long.valueOf(l));
                    }
                    case GTE: {
                        long l = DateFormat.stringToMillis((String)firstValue);
                        return Ranges.atLeast((Comparable)Long.valueOf(l));
                    }
                    case NEQ: 
                    case IN: {
                        break;
                    }
                }
            }
        }
        return Ranges.all();
    }
}

