/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage;

import java.util.HashMap;
import org.apache.kylin.common.util.ImplementationSwitch;
import org.apache.kylin.metadata.model.IStorageAware;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.storage.IStorage;
import org.apache.kylin.storage.IStorageQuery;

public class StorageFactory {
    private static ImplementationSwitch<IStorage> storages;

    public static IStorage storage(IStorageAware aware) {
        return storages.get(aware.getStorageType());
    }

    public static IStorageQuery createQuery(IRealization realization) {
        return StorageFactory.storage(realization).createQuery(realization);
    }

    public static <T> T createEngineAdapter(IStorageAware aware, Class<T> engineInterface) {
        return StorageFactory.storage(aware).adaptToBuildEngine(engineInterface);
    }

    static {
        HashMap<Integer, String> impls = new HashMap<Integer, String>();
        impls.put(0, "org.apache.kylin.storage.hbase.HBaseStorage");
        impls.put(2, "org.apache.kylin.storage.hbase.HBaseStorage");
        impls.put(1, "org.apache.kylin.storage.hybrid.HybridStorage");
        storages = new ImplementationSwitch<IStorage>(impls, IStorage.class);
    }
}

