/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage;

import com.google.common.collect.Range;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kylin.cube.cuboid.Cuboid;

public class StorageContext {
    public static final int DEFAULT_THRESHOLD = 1000000;
    private String connUrl;
    private int threshold = 1000000;
    private int limit = 1000000;
    private int offset;
    private boolean hasSort = false;
    private boolean acceptPartialResult = false;
    private boolean exactAggregation = false;
    private boolean enableLimit = false;
    private boolean enableCoprocessor = false;
    private AtomicLong totalScanCount = new AtomicLong();
    private Cuboid cuboid = null;
    private boolean partialResultReturned = false;
    private Range<Long> reusedPeriod;

    public String getConnUrl() {
        return this.connUrl;
    }

    public void setConnUrl(String connUrl) {
        this.connUrl = connUrl;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int t) {
        this.threshold = t;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int l) {
        this.limit = l;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void enableLimit() {
        this.enableLimit = true;
    }

    public boolean isLimitEnabled() {
        return this.enableLimit;
    }

    public void markSort() {
        this.hasSort = true;
    }

    public boolean hasSort() {
        return this.hasSort;
    }

    public void setCuboid(Cuboid c) {
        this.cuboid = c;
    }

    public Cuboid getCuboid() {
        return this.cuboid;
    }

    public long getTotalScanCount() {
        return this.totalScanCount.get();
    }

    public long increaseTotalScanCount(long count) {
        return this.totalScanCount.addAndGet(count);
    }

    public boolean isAcceptPartialResult() {
        return this.acceptPartialResult;
    }

    public void setAcceptPartialResult(boolean acceptPartialResult) {
        this.acceptPartialResult = acceptPartialResult;
    }

    public boolean isPartialResultReturned() {
        return this.partialResultReturned;
    }

    public void setPartialResultReturned(boolean partialResultReturned) {
        this.partialResultReturned = partialResultReturned;
    }

    public void setExactAggregation(boolean isExactAggregation) {
        this.exactAggregation = isExactAggregation;
    }

    public boolean isExactAggregation() {
        return this.exactAggregation;
    }

    public void enableCoprocessor() {
        this.enableCoprocessor = true;
    }

    public boolean isCoprocessorEnabled() {
        return this.enableCoprocessor;
    }

    public Range<Long> getReusedPeriod() {
        return this.reusedPeriod;
    }

    public void setReusedPeriod(Range<Long> reusedPeriod) {
        this.reusedPeriod = reusedPeriod;
    }
}

