/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.project;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.restclient.Broadcaster;
import org.apache.kylin.common.restclient.CaseInsensitiveStringCache;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.badquery.BadQueryHistoryManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ExternalFilterDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectL2Cache;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectManager {
    private static final Logger logger = LoggerFactory.getLogger(ProjectManager.class);
    private static final ConcurrentHashMap<KylinConfig, ProjectManager> CACHE = new ConcurrentHashMap();
    public static final Serializer<ProjectInstance> PROJECT_SERIALIZER = new JsonSerializer<ProjectInstance>(ProjectInstance.class);
    private KylinConfig config;
    private ProjectL2Cache l2Cache;
    private CaseInsensitiveStringCache<ProjectInstance> projectMap;

    public static ProjectManager getInstance(KylinConfig config) {
        ProjectManager r = CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<ProjectManager> clazz = ProjectManager.class;
        synchronized (ProjectManager.class) {
            r = CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new ProjectManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one singleton exist");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init ProjectManager from " + config, e);
            }
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    private ProjectManager(KylinConfig config) throws IOException {
        logger.info("Initializing ProjectManager with metadata url " + config);
        this.config = config;
        this.projectMap = new CaseInsensitiveStringCache(config, Broadcaster.TYPE.PROJECT);
        this.l2Cache = new ProjectL2Cache(this);
        this.reloadAllProjects();
    }

    public void clearL2Cache() {
        this.l2Cache.clear();
    }

    private void reloadAllProjects() throws IOException {
        ResourceStore store = this.getStore();
        List<String> paths = store.collectResourceRecursively("/project", ".json");
        logger.debug("Loading Project from folder " + store.getReadableResourcePath("/project"));
        for (String path : paths) {
            this.reloadProjectLocalAt(path);
        }
        logger.debug("Loaded " + this.projectMap.size() + " Project(s)");
    }

    public ProjectInstance reloadProjectLocal(String project) throws IOException {
        return this.reloadProjectLocalAt(ProjectInstance.concatResourcePath(project));
    }

    private ProjectInstance reloadProjectLocalAt(String path) throws IOException {
        ProjectInstance projectInstance = this.getStore().getResource(path, ProjectInstance.class, PROJECT_SERIALIZER);
        if (projectInstance == null) {
            logger.warn("reload project at path:" + path + " not found, this:" + this.toString());
            return null;
        }
        projectInstance.init();
        this.projectMap.putLocal(projectInstance.getName(), projectInstance);
        this.clearL2Cache();
        return projectInstance;
    }

    public List<ProjectInstance> listAllProjects() {
        return new ArrayList<ProjectInstance>(this.projectMap.values());
    }

    public ProjectInstance getProject(String projectName) {
        projectName = this.norm(projectName);
        return (ProjectInstance)this.projectMap.get(projectName);
    }

    public ProjectInstance createProject(String projectName, String owner, String description) throws IOException {
        logger.info("Creating project " + projectName);
        ProjectInstance currentProject = this.getProject(projectName);
        if (currentProject != null) {
            throw new IllegalStateException("The project named " + projectName + "already exists");
        }
        currentProject = ProjectInstance.create(projectName, owner, description, null, null);
        this.updateProject(currentProject);
        return currentProject;
    }

    public ProjectInstance dropProject(String projectName) throws IOException {
        if (projectName == null) {
            throw new IllegalArgumentException("Project name not given");
        }
        ProjectInstance projectInstance = this.getProject(projectName);
        if (projectInstance == null) {
            throw new IllegalStateException("The project named " + projectName + " does not exist");
        }
        if (projectInstance.getRealizationCount(null) != 0) {
            throw new IllegalStateException("The project named " + projectName + " can not be deleted because there's still realizations in it. Delete them first.");
        }
        logger.info("Dropping project '" + projectInstance.getName() + "'");
        this.removeProject(projectInstance);
        BadQueryHistoryManager.getInstance(this.config).removeBadQueryHistory(projectName);
        return projectInstance;
    }

    public void updateProject(RealizationType type, String realizationName) throws IOException {
        for (ProjectInstance proj : this.findProjects(type, realizationName)) {
            this.updateProject(proj);
        }
    }

    public ProjectInstance updateProject(ProjectInstance project, String newName, String newDesc) throws IOException {
        if (!project.getName().equals(newName)) {
            ProjectInstance newProject = this.createProject(newName, project.getOwner(), newDesc);
            newProject.setCreateTimeUTC(project.getCreateTimeUTC());
            newProject.recordUpdateTime(System.currentTimeMillis());
            newProject.setRealizationEntries(project.getRealizationEntries());
            newProject.setTables(project.getTables());
            this.removeProject(project);
            this.updateProject(newProject);
            return newProject;
        }
        project.setName(newName);
        project.setDescription(newDesc);
        if (project.getUuid() == null) {
            project.updateRandomUuid();
        }
        this.updateProject(project);
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProject(ProjectInstance prj) throws IOException {
        ProjectInstance projectInstance = prj;
        synchronized (projectInstance) {
            this.getStore().putResource(prj.getResourcePath(), prj, PROJECT_SERIALIZER);
            this.projectMap.put(this.norm(prj.getName()), prj);
            this.clearL2Cache();
        }
    }

    private void removeProject(ProjectInstance proj) throws IOException {
        this.getStore().deleteResource(proj.getResourcePath());
        this.projectMap.remove(this.norm(proj.getName()));
        this.clearL2Cache();
    }

    public boolean isModelInProject(String projectName, String modelName) {
        return this.getProject(projectName).containsModel(modelName);
    }

    public ProjectInstance updateModelToProject(String modelName, String newProjectName) throws IOException {
        this.removeModelFromProjects(modelName);
        return this.addModelToProject(modelName, newProjectName);
    }

    public void removeModelFromProjects(String modelName) throws IOException {
        for (ProjectInstance projectInstance : this.findProjects(modelName)) {
            projectInstance.removeModel(modelName);
            this.updateProject(projectInstance);
        }
    }

    private ProjectInstance addModelToProject(String modelName, String project) throws IOException {
        String newProjectName = ProjectInstance.getNormalizedProjectName(project);
        ProjectInstance newProject = this.getProject(newProjectName);
        if (newProject == null) {
            throw new IllegalArgumentException("Project " + newProjectName + " does not exist.");
        }
        newProject.addModel(modelName);
        this.updateProject(newProject);
        return newProject;
    }

    public ProjectInstance moveRealizationToProject(RealizationType type, String realizationName, String newProjectName, String owner) throws IOException {
        this.removeRealizationsFromProjects(type, realizationName);
        return this.addRealizationToProject(type, realizationName, newProjectName, owner);
    }

    private ProjectInstance addRealizationToProject(RealizationType type, String realizationName, String project, String user) throws IOException {
        String newProjectName = this.norm(project);
        ProjectInstance newProject = this.getProject(newProjectName);
        if (newProject == null) {
            newProject = this.createProject(newProjectName, user, "This is a project automatically added when adding realization " + realizationName + "(" + (Object)((Object)type) + ")");
        }
        newProject.addRealizationEntry(type, realizationName);
        this.updateProject(newProject);
        return newProject;
    }

    public void removeRealizationsFromProjects(RealizationType type, String realizationName) throws IOException {
        for (ProjectInstance projectInstance : this.findProjects(type, realizationName)) {
            projectInstance.removeRealization(type, realizationName);
            this.updateProject(projectInstance);
        }
    }

    public ProjectInstance addTableDescToProject(String[] tableIdentities, String projectName) throws IOException {
        MetadataManager metaMgr = this.getMetadataManager();
        ProjectInstance projectInstance = this.getProject(projectName);
        for (String tableId : tableIdentities) {
            TableDesc table = metaMgr.getTableDesc(tableId);
            if (table == null) {
                throw new IllegalStateException("Cannot find table '" + table + "' in metadata manager");
            }
            projectInstance.addTable(table.getIdentity());
        }
        this.updateProject(projectInstance);
        return projectInstance;
    }

    public void removeTableDescFromProject(String tableIdentities, String projectName) throws IOException {
        MetadataManager metaMgr = this.getMetadataManager();
        ProjectInstance projectInstance = this.getProject(projectName);
        TableDesc table = metaMgr.getTableDesc(tableIdentities);
        if (table == null) {
            throw new IllegalStateException("Cannot find table '" + table + "' in metadata manager");
        }
        projectInstance.removeTable(table.getIdentity());
        this.updateProject(projectInstance);
    }

    public ProjectInstance addExtFilterToProject(String[] filters, String projectName) throws IOException {
        MetadataManager metaMgr = this.getMetadataManager();
        ProjectInstance projectInstance = this.getProject(projectName);
        for (String filterName : filters) {
            ExternalFilterDesc extFilter = metaMgr.getExtFilterDesc(filterName);
            if (extFilter == null) {
                throw new IllegalStateException("Cannot find external filter '" + filterName + "' in metadata manager");
            }
            projectInstance.addExtFilter(filterName);
        }
        this.updateProject(projectInstance);
        return projectInstance;
    }

    public void removeExtFilterFromProject(String filterName, String projectName) throws IOException {
        MetadataManager metaMgr = this.getMetadataManager();
        ProjectInstance projectInstance = this.getProject(projectName);
        ExternalFilterDesc filter = metaMgr.getExtFilterDesc(filterName);
        if (filter == null) {
            throw new IllegalStateException("Cannot find external filter '" + filterName + "' in metadata manager");
        }
        projectInstance.removeExtFilter(filterName);
        this.updateProject(projectInstance);
    }

    public List<ProjectInstance> findProjects(RealizationType type, String realizationName) {
        ArrayList result = Lists.newArrayList();
        block0: for (ProjectInstance prj : this.projectMap.values()) {
            for (RealizationEntry entry : prj.getRealizationEntries()) {
                if (!entry.getType().equals((Object)type) || !entry.getRealization().equalsIgnoreCase(realizationName)) continue;
                result.add(prj);
                continue block0;
            }
        }
        return result;
    }

    private List<ProjectInstance> findProjects(String modelName) {
        ArrayList<ProjectInstance> projects = new ArrayList<ProjectInstance>();
        for (ProjectInstance projectInstance : this.projectMap.values()) {
            if (!projectInstance.containsModel(modelName)) continue;
            projects.add(projectInstance);
        }
        return projects;
    }

    public ExternalFilterDesc getExternalFilterDesc(String project, String extFilter) {
        return this.l2Cache.getExternalFilterDesc(project, extFilter);
    }

    public Map<String, ExternalFilterDesc> listExternalFilterDescs(String project) {
        return this.l2Cache.listExternalFilterDesc(project);
    }

    public List<TableDesc> listDefinedTables(String project) throws IOException {
        return this.l2Cache.listDefinedTables(this.norm(project));
    }

    public Set<TableDesc> listExposedTables(String project) {
        return this.l2Cache.listExposedTables(this.norm(project));
    }

    public Set<ColumnDesc> listExposedColumns(String project, String table) {
        return this.l2Cache.listExposedColumns(this.norm(project), table);
    }

    public boolean isExposedTable(String project, String table) {
        return this.l2Cache.isExposedTable(this.norm(project), table);
    }

    public boolean isExposedColumn(String project, String table, String col) {
        return this.l2Cache.isExposedColumn(this.norm(project), table, col);
    }

    public Set<IRealization> listAllRealizations(String project) {
        return this.l2Cache.listAllRealizations(this.norm(project));
    }

    public Set<IRealization> getRealizationsByTable(String project, String tableName) {
        return this.l2Cache.getRealizationsByTable(this.norm(project), tableName.toUpperCase());
    }

    public List<IRealization> getOnlineRealizationByFactTable(String project, String factTable) {
        return this.l2Cache.getOnlineRealizationByFactTable(this.norm(project), factTable.toUpperCase());
    }

    public List<MeasureDesc> listEffectiveRewriteMeasures(String project, String factTable) {
        return this.l2Cache.listEffectiveRewriteMeasures(this.norm(project), factTable.toUpperCase(), true);
    }

    public List<MeasureDesc> listEffectiveMeasures(String project, String factTable) {
        return this.l2Cache.listEffectiveRewriteMeasures(this.norm(project), factTable.toUpperCase(), false);
    }

    KylinConfig getConfig() {
        return this.config;
    }

    ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    MetadataManager getMetadataManager() {
        return MetadataManager.getInstance(this.config);
    }

    private String norm(String project) {
        return project;
    }
}

