/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.StringSplitter;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DatabaseDesc;
import org.apache.kylin.metadata.model.ISourceAware;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class TableDesc
extends RootPersistentEntity
implements ISourceAware {
    public static final String TABLE_TYPE_VIRTUAL_VIEW = "VIRTUAL_VIEW";
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="columns")
    private ColumnDesc[] columns;
    @JsonProperty(value="source_type")
    private int sourceType = 0;
    @JsonProperty(value="table_type")
    private String tableType;
    private static final String materializedTableNamePrefix = "kylin_intermediate_";
    private DatabaseDesc database = new DatabaseDesc();
    private String identity = null;

    public TableDesc() {
    }

    public TableDesc(TableDesc other) {
        this.name = other.getName();
        this.columns = other.getColumns();
        this.database.setName(other.getDatabase());
        this.tableType = other.getTableType();
    }

    public ColumnDesc findColumnByName(String name) {
        int lastIndexOfDot = name.lastIndexOf(".");
        if (lastIndexOfDot >= 0) {
            name = name.substring(lastIndexOfDot + 1);
        }
        for (ColumnDesc c : this.columns) {
            if (!name.equalsIgnoreCase(c.getName())) continue;
            return c;
        }
        return null;
    }

    public String getResourcePath() {
        return TableDesc.concatResourcePath(this.getIdentity());
    }

    public String getResourcePathV1() {
        return TableDesc.concatResourcePath(this.name);
    }

    public String getIdentity() {
        if (this.identity == null) {
            this.identity = String.format("%s.%s", this.getDatabase().toUpperCase(), this.getName()).toUpperCase();
        }
        return this.identity;
    }

    public static String concatResourcePath(String tableIdentity) {
        return "/table/" + tableIdentity + ".json";
    }

    public static String concatExdResourcePath(String tableIdentity) {
        return "/table_exd/" + tableIdentity + ".json";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            String[] splits = StringSplitter.split(name, ".");
            if (splits.length == 2) {
                this.setDatabase(splits[0]);
                this.name = splits[1];
            } else if (splits.length == 1) {
                this.name = splits[0];
            }
        } else {
            this.name = name;
        }
    }

    @JsonProperty(value="database")
    public String getDatabase() {
        return this.database.getName();
    }

    @JsonProperty(value="database")
    public void setDatabase(String database) {
        this.database.setName(database);
    }

    public ColumnDesc[] getColumns() {
        return this.columns;
    }

    public void setColumns(ColumnDesc[] columns) {
        this.columns = columns;
    }

    public int getMaxColumnIndex() {
        int max = -1;
        for (ColumnDesc col : this.columns) {
            int idx = col.getZeroBasedIndex();
            max = Math.max(max, idx);
        }
        return max;
    }

    public int getColumnCount() {
        return this.getMaxColumnIndex() + 1;
    }

    public void init() {
        if (this.name != null) {
            this.name = this.name.toUpperCase();
        }
        if (this.getDatabase() != null) {
            this.setDatabase(this.getDatabase().toUpperCase());
        }
        if (this.columns != null) {
            Arrays.sort(this.columns, new Comparator<ColumnDesc>(){

                @Override
                public int compare(ColumnDesc col1, ColumnDesc col2) {
                    Integer id1 = Integer.parseInt(col1.getId());
                    Integer id2 = Integer.parseInt(col2.getId());
                    return id1.compareTo(id2);
                }
            });
            for (ColumnDesc col : this.columns) {
                col.init(this);
            }
        }
    }

    @Override
    public int hashCode() {
        return this.getIdentity().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableDesc other = (TableDesc)obj;
        return this.getIdentity().equals(other.getIdentity());
    }

    public String getMaterializedName() {
        return materializedTableNamePrefix + this.database.getName() + "_" + this.name;
    }

    public String toString() {
        return "TableDesc [database=" + this.getDatabase() + " name=" + this.name + "]";
    }

    public static TableDesc mockup(String tableName) {
        TableDesc mockup = new TableDesc();
        mockup.setName(tableName);
        return mockup;
    }

    @Override
    public int getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(int sourceType) {
        this.sourceType = sourceType;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }
}

