/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.LookupDesc;
import org.apache.kylin.metadata.model.ModelDimensionDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DataModelDesc
extends RootPersistentEntity {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="fact_table")
    private String factTable;
    @JsonProperty(value="lookups")
    private LookupDesc[] lookups;
    @JsonProperty(value="dimensions")
    private List<ModelDimensionDesc> dimensions;
    @JsonProperty(value="metrics")
    private String[] metrics;
    @JsonProperty(value="filter_condition")
    private String filterCondition;
    @JsonProperty(value="partition_desc")
    PartitionDesc partitionDesc;
    @JsonProperty(value="capacity")
    private RealizationCapacity capacity = RealizationCapacity.MEDIUM;
    private TableDesc factTableDesc;
    private List<TableDesc> lookupTableDescs = Lists.newArrayList();
    private List<String> errors = new ArrayList<String>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Collection<String> getAllTables() {
        HashSet ret = Sets.newHashSet();
        ret.add(this.factTable);
        for (LookupDesc lookupDesc : this.lookups) {
            ret.add(lookupDesc.getTable());
        }
        return ret;
    }

    public String getFactTable() {
        return this.factTable;
    }

    public TableDesc getFactTableDesc() {
        return this.factTableDesc;
    }

    public List<TableDesc> getLookupTableDescs() {
        return this.lookupTableDescs;
    }

    public void setFactTable(String factTable) {
        this.factTable = factTable.toUpperCase();
    }

    public LookupDesc[] getLookups() {
        return this.lookups;
    }

    public void setLookups(LookupDesc[] lookups) {
        this.lookups = lookups;
    }

    public boolean isFactTable(String factTable) {
        return this.factTable.equalsIgnoreCase(factTable);
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public PartitionDesc getPartitionDesc() {
        return this.partitionDesc;
    }

    public void setPartitionDesc(PartitionDesc partitionDesc) {
        this.partitionDesc = partitionDesc;
    }

    public RealizationCapacity getCapacity() {
        return this.capacity;
    }

    public void setCapacity(RealizationCapacity capacity) {
        this.capacity = capacity;
    }

    public TblColRef findPKByFK(TblColRef fk, String joinType) {
        assert (this.isFactTable(fk.getTable()));
        TblColRef candidate = null;
        for (LookupDesc dim : this.lookups) {
            int find;
            JoinDesc join = dim.getJoin();
            if (join == null || joinType != null && !joinType.equals(join.getType()) || (find = ArrayUtils.indexOf((Object[])join.getForeignKeyColumns(), (Object)fk)) < 0) continue;
            candidate = join.getPrimaryKeyColumns()[find];
            if (join.getForeignKeyColumns().length == 1) break;
        }
        return candidate;
    }

    public void init(Map<String, TableDesc> tables) {
        this.factTable = this.factTable.toUpperCase();
        this.factTableDesc = tables.get(this.factTable.toUpperCase());
        if (this.factTableDesc == null) {
            throw new IllegalStateException("Fact table does not exist:" + this.factTable);
        }
        this.initJoinColumns(tables);
        ModelDimensionDesc.capicalizeStrings(this.dimensions);
        this.initPartitionDesc(tables);
    }

    private void initPartitionDesc(Map<String, TableDesc> tables) {
        if (this.partitionDesc != null) {
            this.partitionDesc.init(tables);
        }
    }

    private void initJoinColumns(Map<String, TableDesc> tables) {
        for (LookupDesc lookup : this.lookups) {
            int i;
            lookup.setTable(lookup.getTable().toUpperCase());
            TableDesc dimTable = tables.get(lookup.getTable());
            if (dimTable == null) {
                throw new IllegalStateException("Table " + lookup.getTable() + " does not exist for " + this);
            }
            this.lookupTableDescs.add(dimTable);
            JoinDesc join = lookup.getJoin();
            if (join == null) continue;
            StringUtil.toUpperCaseArray(join.getForeignKey(), join.getForeignKey());
            StringUtil.toUpperCaseArray(join.getPrimaryKey(), join.getPrimaryKey());
            Object[] pks = join.getPrimaryKey();
            TblColRef[] pkCols = new TblColRef[pks.length];
            for (int i2 = 0; i2 < pks.length; ++i2) {
                ColumnDesc col = dimTable.findColumnByName(pks[i2]);
                if (col == null) {
                    throw new IllegalStateException("Can't find column " + pks[i2] + " in table " + dimTable.getIdentity());
                }
                TblColRef colRef = new TblColRef(col);
                pks[i2] = colRef.getName();
                pkCols[i2] = colRef;
            }
            join.setPrimaryKeyColumns(pkCols);
            Object[] fks = join.getForeignKey();
            TblColRef[] fkCols = new TblColRef[fks.length];
            for (i = 0; i < fks.length; ++i) {
                ColumnDesc col = this.factTableDesc.findColumnByName(fks[i]);
                if (col == null) {
                    throw new IllegalStateException("Can't find column " + fks[i] + " in table " + this.getFactTable());
                }
                TblColRef colRef = new TblColRef(col);
                fks[i] = colRef.getName();
                fkCols[i] = colRef;
            }
            join.setForeignKeyColumns(fkCols);
            if (pkCols.length != fkCols.length) {
                throw new IllegalStateException("Primary keys(" + lookup.getTable() + ")" + Arrays.toString(pks) + " are not consistent with Foreign keys(" + this.getFactTable() + ") " + Arrays.toString(fks));
            }
            for (i = 0; i < fkCols.length; ++i) {
                if (fkCols[i].getDatatype().equals(pkCols[i].getDatatype())) continue;
                throw new IllegalStateException("Primary key " + lookup.getTable() + "." + pkCols[i].getName() + "." + pkCols[i].getDatatype() + " are not consistent with Foreign key " + this.getFactTable() + "." + fkCols[i].getName() + "." + fkCols[i].getDatatype());
            }
        }
    }

    public void addError(String message) {
        this.addError(message, false);
    }

    public void addError(String message, boolean silent) {
        if (!silent) {
            throw new IllegalStateException(message);
        }
        this.errors.add(message);
    }

    public List<String> getError() {
        return this.errors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataModelDesc modelDesc = (DataModelDesc)o;
        if (!this.name.equals(modelDesc.name)) {
            return false;
        }
        return this.getFactTable().equals(modelDesc.getFactTable());
    }

    @Override
    public int hashCode() {
        int result = 0;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.getFactTable().hashCode();
        return result;
    }

    public String toString() {
        return "DataModelDesc [name=" + this.name + "]";
    }

    public String getResourcePath() {
        return DataModelDesc.concatResourcePath(this.name);
    }

    public static String concatResourcePath(String descName) {
        return "/model_desc/" + descName + ".json";
    }

    public List<ModelDimensionDesc> getDimensions() {
        return this.dimensions;
    }

    public String[] getMetrics() {
        return this.metrics;
    }

    public void setDimensions(List<ModelDimensionDesc> dimensions) {
        this.dimensions = dimensions;
    }

    public void setMetrics(String[] metrics) {
        this.metrics = metrics;
    }

    public static DataModelDesc getCopyOf(DataModelDesc dataModelDesc) {
        DataModelDesc newDataModelDesc = new DataModelDesc();
        newDataModelDesc.setName(dataModelDesc.getName());
        newDataModelDesc.setCapacity(dataModelDesc.getCapacity());
        newDataModelDesc.setDescription(dataModelDesc.getDescription());
        newDataModelDesc.setDimensions(dataModelDesc.getDimensions());
        newDataModelDesc.setFilterCondition(dataModelDesc.getFilterCondition());
        newDataModelDesc.setFactTable(dataModelDesc.getFactTable());
        newDataModelDesc.setLookups(dataModelDesc.getLookups());
        newDataModelDesc.setMetrics(dataModelDesc.getMetrics());
        newDataModelDesc.setPartitionDesc(PartitionDesc.getCopyOf(dataModelDesc.getPartitionDesc()));
        newDataModelDesc.updateRandomUuid();
        return newDataModelDesc;
    }

    public static enum RealizationCapacity {
        SMALL,
        MEDIUM,
        LARGE;

    }
}

