/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter.UDF;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.FunctionTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.UDF.MassInValueProvider;
import org.apache.kylin.metadata.filter.UDF.MassInValueProviderFactory;
import org.apache.kylin.metadata.filter.function.Functions;
import org.apache.kylin.metadata.model.ExternalFilterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MassInTupleFilter
extends FunctionTupleFilter {
    public static final Logger logger = LoggerFactory.getLogger(MassInTupleFilter.class);
    public static MassInValueProviderFactory VALUE_PROVIDER_FACTORY = null;
    private transient MassInValueProvider valueProvider = null;
    private transient TblColRef column;
    private String filterTableName;
    private String filterTableResourceIdentifier;
    private Functions.FilterTableType filterTableType;

    public MassInTupleFilter() {
        super(Lists.newArrayList(), TupleFilter.FilterOperatorEnum.MASSIN);
    }

    @Override
    public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        Preconditions.checkNotNull((Object)tuple);
        Preconditions.checkNotNull((Object)this.column);
        Object colValue = tuple.getValue(this.column);
        if (this.valueProvider == null) {
            this.valueProvider = VALUE_PROVIDER_FACTORY.getProvider(this.filterTableType, this.filterTableResourceIdentifier, this.column);
        }
        boolean ret = this.valueProvider.getMassInValues().contains(colValue);
        return ret;
    }

    @Override
    public Collection<?> getValues() {
        return null;
    }

    @Override
    public boolean isEvaluable() {
        return true;
    }

    @Override
    public void addChild(TupleFilter child) {
        if (child instanceof ColumnTupleFilter) {
            super.addChild(child);
            ColumnTupleFilter columnFilter = (ColumnTupleFilter)child;
            if (this.column != null) {
                throw new IllegalStateException("Duplicate columns! old is " + this.column.getName() + " and new is " + columnFilter.getColumn().getName());
            }
            this.column = columnFilter.getColumn();
        } else if (child instanceof ConstantTupleFilter) {
            if (this.filterTableName == null) {
                this.filterTableName = (String)child.getValues().iterator().next();
                ExternalFilterDesc externalFilterDesc = MetadataManager.getInstance(KylinConfig.getInstanceFromEnv()).getExtFilterDesc(this.filterTableName);
                if (externalFilterDesc == null) {
                    throw new IllegalArgumentException("External filter named " + this.filterTableName + " is not found");
                }
                this.filterTableType = externalFilterDesc.getFilterTableType();
                this.filterTableResourceIdentifier = externalFilterDesc.getFilterResourceIdentifier();
            }
        } else {
            throw new IllegalStateException("MassInTupleFilter only has two children: one ColumnTupleFilter and one ConstantTupleFilter");
        }
    }

    public void serialize(IFilterCodeSystem cs, ByteBuffer buffer) {
        BytesUtil.writeUTFString(this.filterTableName, buffer);
        BytesUtil.writeUTFString(this.filterTableResourceIdentifier, buffer);
        BytesUtil.writeUTFString(this.filterTableType.toString(), buffer);
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        this.filterTableName = BytesUtil.readUTFString(buffer);
        this.filterTableResourceIdentifier = BytesUtil.readUTFString(buffer);
        this.filterTableType = Functions.FilterTableType.valueOf(BytesUtil.readUTFString(buffer));
    }

    public static boolean containsMassInTupleFilter(TupleFilter filter) {
        if (filter == null) {
            return false;
        }
        if (filter instanceof MassInTupleFilter) {
            return true;
        }
        for (TupleFilter tupleFilter : filter.getChildren()) {
            if (!MassInTupleFilter.containsMassInTupleFilter(tupleFilter)) continue;
            return true;
        }
        return false;
    }
}

