/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.filter.BuildInFunctionTupleFilter;
import org.apache.kylin.metadata.filter.CaseTupleFilter;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.DynamicTupleFilter;
import org.apache.kylin.metadata.filter.ExtractTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.UDF.MassInTupleFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleFilterSerializer {
    private static final Logger logger = LoggerFactory.getLogger(TupleFilterSerializer.class);
    private static final int BUFFER_SIZE = 65536;
    private static final Map<Integer, TupleFilter.FilterOperatorEnum> ID_OP_MAP = new HashMap<Integer, TupleFilter.FilterOperatorEnum>();

    public static byte[] serialize(TupleFilter rootFilter, IFilterCodeSystem<?> cs) {
        return TupleFilterSerializer.serialize(rootFilter, null, cs);
    }

    public static byte[] serialize(TupleFilter rootFilter, Decorator decorator, IFilterCodeSystem<?> cs) {
        ByteBuffer buffer;
        int bufferSize = 65536;
        while (true) {
            try {
                buffer = ByteBuffer.allocate(bufferSize);
                TupleFilterSerializer.internalSerialize(rootFilter, decorator, buffer, cs);
            }
            catch (BufferOverflowException e) {
                logger.info("Buffer size {} cannot hold the filter, resizing to 4 times", (Object)bufferSize);
                bufferSize *= 4;
                continue;
            }
            break;
        }
        byte[] result = new byte[buffer.position()];
        System.arraycopy(buffer.array(), 0, result, 0, buffer.position());
        return result;
    }

    private static void internalSerialize(TupleFilter filter, Decorator decorator, ByteBuffer buffer, IFilterCodeSystem<?> cs) {
        if (decorator != null) {
            filter = decorator.onSerialize(filter);
        }
        if (filter == null) {
            return;
        }
        if (filter.hasChildren()) {
            TupleFilterSerializer.serializeFilter(1, filter, buffer, cs);
            for (TupleFilter tupleFilter : filter.getChildren()) {
                TupleFilterSerializer.internalSerialize(tupleFilter, decorator, buffer, cs);
            }
            TupleFilterSerializer.serializeFilter(-1, filter, buffer, cs);
        } else {
            TupleFilterSerializer.serializeFilter(0, filter, buffer, cs);
        }
    }

    private static void serializeFilter(int flag, TupleFilter filter, ByteBuffer buffer, IFilterCodeSystem<?> cs) {
        if (flag < 0) {
            BytesUtil.writeVInt(-1, buffer);
        } else {
            int opVal = filter.getOperator().getValue();
            BytesUtil.writeVInt(opVal, buffer);
            filter.serialize(cs, buffer);
            BytesUtil.writeVInt(flag, buffer);
        }
    }

    public static TupleFilter deserialize(byte[] bytes, IFilterCodeSystem<?> cs) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        TupleFilter rootFilter = null;
        Stack<TupleFilter> parentStack = new Stack<TupleFilter>();
        while (buffer.hasRemaining()) {
            int hasChild;
            int opVal = BytesUtil.readVInt(buffer);
            if (opVal < 0) {
                parentStack.pop();
                continue;
            }
            TupleFilter filter = TupleFilterSerializer.createTupleFilter(opVal);
            filter.deserialize(cs, buffer);
            if (rootFilter == null) {
                rootFilter = filter;
                parentStack.push(filter);
                BytesUtil.readVInt(buffer);
                continue;
            }
            TupleFilter parentFilter = (TupleFilter)parentStack.peek();
            if (parentFilter != null) {
                parentFilter.addChild(filter);
            }
            if ((hasChild = BytesUtil.readVInt(buffer)) != 1) continue;
            parentStack.push(filter);
        }
        return rootFilter;
    }

    private static TupleFilter createTupleFilter(int opVal) {
        TupleFilter.FilterOperatorEnum op = ID_OP_MAP.get(opVal);
        if (op == null) {
            throw new IllegalStateException("operator value is " + opVal);
        }
        TupleFilter filter = null;
        switch (op) {
            case AND: 
            case OR: 
            case NOT: {
                filter = new LogicalTupleFilter(op);
                break;
            }
            case EQ: 
            case NEQ: 
            case LT: 
            case LTE: 
            case GT: 
            case GTE: 
            case IN: 
            case ISNULL: 
            case ISNOTNULL: {
                filter = new CompareTupleFilter(op);
                break;
            }
            case EXTRACT: {
                filter = new ExtractTupleFilter(op);
                break;
            }
            case CASE: {
                filter = new CaseTupleFilter();
                break;
            }
            case COLUMN: {
                filter = new ColumnTupleFilter(null);
                break;
            }
            case CONSTANT: {
                filter = new ConstantTupleFilter();
                break;
            }
            case DYNAMIC: {
                filter = new DynamicTupleFilter(null);
                break;
            }
            case FUNCTION: {
                filter = new BuildInFunctionTupleFilter(null);
                break;
            }
            case MASSIN: {
                filter = new MassInTupleFilter();
                break;
            }
            default: {
                throw new IllegalStateException("Error FilterOperatorEnum: " + op.getValue());
            }
        }
        return filter;
    }

    static {
        for (TupleFilter.FilterOperatorEnum op : TupleFilter.FilterOperatorEnum.values()) {
            ID_OP_MAP.put(op.getValue(), op);
        }
    }

    public static interface Decorator {
        public TupleFilter onSerialize(TupleFilter var1);
    }
}

