/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.FunctionTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.function.BuiltInMethod;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInFunctionTupleFilter
extends FunctionTupleFilter {
    public static final Logger logger = LoggerFactory.getLogger(BuildInFunctionTupleFilter.class);
    private String name;
    private TupleFilter columnContainerFilter;
    private int colPosition;
    private Method method;
    private List<Serializable> methodParams = Lists.newArrayList();
    private boolean isValid = false;

    public BuildInFunctionTupleFilter(String name) {
        super(Lists.newArrayList(), TupleFilter.FilterOperatorEnum.FUNCTION);
        if (name != null) {
            this.name = name.toUpperCase();
            this.initMethod();
        }
    }

    public String getName() {
        return this.name;
    }

    public TblColRef getColumn() {
        if (this.columnContainerFilter == null) {
            return null;
        }
        if (this.columnContainerFilter instanceof ColumnTupleFilter) {
            return ((ColumnTupleFilter)this.columnContainerFilter).getColumn();
        }
        if (this.columnContainerFilter instanceof BuildInFunctionTupleFilter) {
            return ((BuildInFunctionTupleFilter)this.columnContainerFilter).getColumn();
        }
        throw new UnsupportedOperationException("Wrong type TupleFilter in FunctionTupleFilter.");
    }

    public Object invokeFunction(Object input) throws InvocationTargetException, IllegalAccessException {
        if (this.columnContainerFilter instanceof ColumnTupleFilter) {
            this.methodParams.set(this.colPosition, (Serializable)input);
        } else if (this.columnContainerFilter instanceof BuildInFunctionTupleFilter) {
            this.methodParams.set(this.colPosition, (Serializable)((BuildInFunctionTupleFilter)this.columnContainerFilter).invokeFunction(input));
        }
        return this.method.invoke(null, this.methodParams.toArray());
    }

    public boolean isValid() {
        return this.isValid && this.method != null && this.methodParams.size() == this.children.size();
    }

    @Override
    public void addChild(TupleFilter child) {
        if (child instanceof ColumnTupleFilter || child instanceof BuildInFunctionTupleFilter) {
            this.columnContainerFilter = child;
            this.colPosition = this.methodParams.size();
            this.methodParams.add(null);
        } else if (child instanceof ConstantTupleFilter) {
            Serializable constVal = (Serializable)child.getValues().iterator().next();
            try {
                Class clazz = Primitives.wrap(this.method.getParameterTypes()[this.methodParams.size()]);
                if (!Primitives.isWrapperType((Class)clazz)) {
                    this.methodParams.add(constVal);
                } else {
                    this.methodParams.add((Serializable)clazz.cast(clazz.getDeclaredMethod("valueOf", String.class).invoke(null, constVal)));
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
                this.isValid = false;
            }
        }
        super.addChild(child);
    }

    @Override
    public boolean isEvaluable() {
        return false;
    }

    @Override
    public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        throw new UnsupportedOperationException("Function filter cannot be evaluated immediately");
    }

    public Collection<String> getValues() {
        throw new UnsupportedOperationException("Function filter cannot be evaluated immediately");
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        BytesUtil.writeUTFString(this.name, buffer);
        BytesUtil.writeVInt(this.colPosition, buffer);
        BytesUtil.writeVInt(this.isValid ? 1 : 0, buffer);
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        this.name = BytesUtil.readUTFString(buffer);
        this.initMethod();
        this.colPosition = BytesUtil.readVInt(buffer);
        this.isValid = BytesUtil.readVInt(buffer) == 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("(");
        for (int i = 0; i < this.methodParams.size(); ++i) {
            if (this.colPosition == i) {
                sb.append(this.columnContainerFilter);
            } else {
                sb.append(this.methodParams.get(i));
            }
            if (i >= this.methodParams.size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private void initMethod() {
        if (BuiltInMethod.MAP.containsKey((Object)this.name)) {
            this.method = ((BuiltInMethod)((Object)BuiltInMethod.MAP.get((Object)this.name))).method;
            this.isValid = true;
        }
    }
}

