/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.restclient.Broadcaster;
import org.apache.kylin.common.restclient.CaseInsensitiveStringCache;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.ExternalFilterDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataManager {
    private static final Logger logger = LoggerFactory.getLogger(MetadataManager.class);
    public static final Serializer<TableDesc> TABLE_SERIALIZER = new JsonSerializer<TableDesc>(TableDesc.class);
    public static final Serializer<DataModelDesc> MODELDESC_SERIALIZER = new JsonSerializer<DataModelDesc>(DataModelDesc.class);
    public static final Serializer<ExternalFilterDesc> EXTERNAL_FILTER_DESC_SERIALIZER = new JsonSerializer<ExternalFilterDesc>(ExternalFilterDesc.class);
    private static final ConcurrentHashMap<KylinConfig, MetadataManager> CACHE = new ConcurrentHashMap();
    private KylinConfig config;
    private CaseInsensitiveStringCache<TableDesc> srcTableMap;
    private CaseInsensitiveStringCache<Map<String, String>> srcTableExdMap;
    private CaseInsensitiveStringCache<DataModelDesc> dataModelDescMap;
    private CaseInsensitiveStringCache<ExternalFilterDesc> extFilterMap;

    public static MetadataManager getInstance(KylinConfig config) {
        MetadataManager r = CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<MetadataManager> clazz = MetadataManager.class;
        synchronized (MetadataManager.class) {
            r = CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new MetadataManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one singleton exist");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init MetadataManager from " + config, e);
            }
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    private MetadataManager(KylinConfig config) throws IOException {
        this.init(config);
    }

    public void reload() {
        MetadataManager.clearCache();
        MetadataManager.getInstance(this.config);
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    public List<TableDesc> listAllTables() {
        return Lists.newArrayList(this.srcTableMap.values());
    }

    public List<ExternalFilterDesc> listAllExternalFilters() {
        return Lists.newArrayList(this.extFilterMap.values());
    }

    public Map<String, TableDesc> getAllTablesMap() {
        return Collections.unmodifiableMap(this.srcTableMap.getMap());
    }

    public Map<String, Map<String, String>> listAllTableExdMap() {
        return this.srcTableExdMap.getMap();
    }

    public TableDesc getTableDesc(String tableName) {
        if (tableName != null && tableName.indexOf(".") < 0) {
            tableName = "DEFAULT." + tableName;
        }
        TableDesc result = (TableDesc)this.srcTableMap.get(tableName.toUpperCase());
        return result;
    }

    public ExternalFilterDesc getExtFilterDesc(String filterTableName) {
        ExternalFilterDesc result = (ExternalFilterDesc)this.extFilterMap.get(filterTableName);
        return result;
    }

    public Map<String, String> getTableDescExd(String tableName) {
        String tableIdentity = tableName;
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.srcTableExdMap.containsKey(tableIdentity)) {
            Map tmp = (Map)this.srcTableExdMap.get(tableIdentity);
            for (Map.Entry entry : tmp.entrySet()) {
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
            result.put("EXD_STATUS", "true");
        } else {
            result.put("EXD_STATUS", "false");
        }
        return result;
    }

    public void saveSourceTable(TableDesc srcTable) throws IOException {
        if (srcTable.getUuid() == null || srcTable.getIdentity() == null) {
            throw new IllegalArgumentException();
        }
        srcTable.init();
        String path = srcTable.getResourcePath();
        this.getStore().putResource(path, srcTable, TABLE_SERIALIZER);
        this.srcTableMap.put(srcTable.getIdentity(), srcTable);
    }

    public void removeSourceTable(String tableIdentity) throws IOException {
        String path = TableDesc.concatResourcePath(tableIdentity);
        this.getStore().deleteResource(path);
        this.srcTableMap.remove(tableIdentity);
    }

    public void saveExternalFilter(ExternalFilterDesc desc) throws IOException {
        if (desc.getUuid() == null) {
            throw new IllegalArgumentException("UUID not set.");
        }
        String path = desc.getResourcePath();
        this.getStore().putResource(path, desc, EXTERNAL_FILTER_DESC_SERIALIZER);
        desc = this.reloadExternalFilterAt(path);
        this.extFilterMap.put(desc.getName(), desc);
    }

    public void removeExternalFilter(String name) throws IOException {
        String path = ExternalFilterDesc.concatResourcePath(name);
        this.getStore().deleteResource(path);
        this.extFilterMap.remove(name);
    }

    private void init(KylinConfig config) throws IOException {
        this.config = config;
        this.srcTableMap = new CaseInsensitiveStringCache(config, Broadcaster.TYPE.TABLE);
        this.srcTableExdMap = new CaseInsensitiveStringCache(config, Broadcaster.TYPE.TABLE);
        this.dataModelDescMap = new CaseInsensitiveStringCache(config, Broadcaster.TYPE.DATA_MODEL);
        this.extFilterMap = new CaseInsensitiveStringCache(config, Broadcaster.TYPE.EXTERNAL_FILTER);
        this.reloadAllSourceTable();
        this.reloadAllSourceTableExd();
        this.reloadAllDataModel();
        this.reloadAllExternalFilter();
    }

    private void reloadAllSourceTableExd() throws IOException {
        ResourceStore store = this.getStore();
        logger.debug("Reloading SourceTable exd info from folder " + store.getReadableResourcePath("/table_exd"));
        this.srcTableExdMap.clear();
        List<String> paths = store.collectResourceRecursively("/table_exd", ".json");
        for (String path : paths) {
            this.reloadSourceTableExdAt(path);
        }
        logger.debug("Loaded " + this.srcTableExdMap.size() + " SourceTable EXD(s)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> reloadSourceTableExdAt(String path) throws IOException {
        HashMap attrs = Maps.newHashMap();
        ResourceStore store = this.getStore();
        RawResource res = store.getResource(path);
        if (res == null) {
            logger.warn("Failed to get table exd info from " + path);
            return null;
        }
        try (InputStream is = res.inputStream;){
            attrs.putAll(JsonUtil.readValue(is, HashMap.class));
        }
        String file = path;
        if (file.indexOf("/") > -1) {
            file = file.substring(file.lastIndexOf("/") + 1);
        }
        String tableIdentity = file.substring(0, file.length() - ".json".length()).toUpperCase();
        this.srcTableExdMap.putLocal(tableIdentity, (Map<String, String>)attrs);
        return attrs;
    }

    private void reloadAllExternalFilter() throws IOException {
        ResourceStore store = this.getStore();
        logger.debug("Reloading ExternalFilter from folder " + store.getReadableResourcePath("/ext_filter"));
        this.extFilterMap.clear();
        List<String> paths = store.collectResourceRecursively("/ext_filter", ".json");
        for (String path : paths) {
            this.reloadExternalFilterAt(path);
        }
        logger.debug("Loaded " + this.extFilterMap.size() + " SourceTable(s)");
    }

    private void reloadAllSourceTable() throws IOException {
        ResourceStore store = this.getStore();
        logger.debug("Reloading SourceTable from folder " + store.getReadableResourcePath("/table"));
        this.srcTableMap.clear();
        List<String> paths = store.collectResourceRecursively("/table", ".json");
        for (String path : paths) {
            this.reloadSourceTableAt(path);
        }
        logger.debug("Loaded " + this.srcTableMap.size() + " SourceTable(s)");
    }

    private TableDesc reloadSourceTableAt(String path) throws IOException {
        ResourceStore store = this.getStore();
        TableDesc t = store.getResource(path, TableDesc.class, TABLE_SERIALIZER);
        if (t == null) {
            return null;
        }
        t.init();
        String tableIdentity = t.getIdentity();
        this.srcTableMap.putLocal(tableIdentity, t);
        return t;
    }

    private ExternalFilterDesc reloadExternalFilterAt(String path) throws IOException {
        ResourceStore store = this.getStore();
        ExternalFilterDesc t = store.getResource(path, ExternalFilterDesc.class, EXTERNAL_FILTER_DESC_SERIALIZER);
        if (t == null) {
            return null;
        }
        this.extFilterMap.putLocal(t.getName(), t);
        return t;
    }

    public void reloadExtFilter(String extFilterName) throws IOException {
        this.reloadExternalFilterAt(ExternalFilterDesc.concatResourcePath(extFilterName));
    }

    public void reloadSourceTableExt(String tableIdentity) throws IOException {
        this.reloadSourceTableExdAt(TableDesc.concatExdResourcePath(tableIdentity));
    }

    public void reloadSourceTable(String tableIdentity) throws IOException {
        this.reloadSourceTableAt(TableDesc.concatResourcePath(tableIdentity));
    }

    public void reloadTableCache(String tableIdentity) throws IOException {
        this.reloadSourceTableExt(tableIdentity);
        this.reloadSourceTable(tableIdentity);
    }

    public DataModelDesc getDataModelDesc(String name) {
        return (DataModelDesc)this.dataModelDescMap.get(name);
    }

    public List<DataModelDesc> getModels() {
        return new ArrayList<DataModelDesc>(this.dataModelDescMap.values());
    }

    public List<DataModelDesc> getModels(String projectName) throws IOException {
        ProjectInstance projectInstance = ProjectManager.getInstance(this.config).getProject(projectName);
        HashSet<DataModelDesc> ret = new HashSet<DataModelDesc>();
        if (projectInstance != null && projectInstance.getModels() != null) {
            for (String modelName : projectInstance.getModels()) {
                DataModelDesc model = this.getDataModelDesc(modelName);
                if (null != model) {
                    ret.add(model);
                    continue;
                }
                logger.error("Failed to load model" + modelName);
            }
        }
        RealizationRegistry registry = RealizationRegistry.getInstance(this.config);
        for (RealizationEntry realization : projectInstance.getRealizationEntries()) {
            IRealization rel = registry.getRealization(realization.getType(), realization.getRealization());
            if (rel != null) {
                DataModelDesc modelDesc = rel.getDataModelDesc();
                if (modelDesc == null || ret.contains(modelDesc)) continue;
                ProjectManager.getInstance(this.config).updateModelToProject(modelDesc.getName(), projectName);
                ret.add(modelDesc);
                continue;
            }
            logger.warn("Realization '" + realization + "' defined under project '" + projectInstance + "' is not found");
        }
        return new ArrayList<DataModelDesc>(ret);
    }

    public boolean isTableInModel(String tableName, String projectName) throws IOException {
        for (DataModelDesc modelDesc : this.getModels(projectName)) {
            if (!modelDesc.getAllTables().contains(tableName.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isTableInAnyModel(String tableName) {
        for (DataModelDesc modelDesc : this.getModels()) {
            if (!modelDesc.getAllTables().contains(tableName.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    private void reloadAllDataModel() throws IOException {
        ResourceStore store = this.getStore();
        logger.debug("Reloading DataModel from folder " + store.getReadableResourcePath("/model_desc"));
        this.dataModelDescMap.clear();
        List<String> paths = store.collectResourceRecursively("/model_desc", ".json");
        for (String path : paths) {
            try {
                this.reloadDataModelDescAt(path);
            }
            catch (IllegalStateException e) {
                logger.error("Error to load DataModel at " + path, (Throwable)e);
            }
        }
        logger.debug("Loaded " + this.dataModelDescMap.size() + " DataModel(s)");
    }

    public DataModelDesc reloadDataModelDesc(String name) {
        return this.reloadDataModelDescAt(DataModelDesc.concatResourcePath(name));
    }

    private DataModelDesc reloadDataModelDescAt(String path) {
        ResourceStore store = this.getStore();
        try {
            DataModelDesc dataModelDesc = store.getResource(path, DataModelDesc.class, MODELDESC_SERIALIZER);
            dataModelDesc.init(this.getAllTablesMap());
            this.dataModelDescMap.putLocal(dataModelDesc.getName(), dataModelDesc);
            return dataModelDesc;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error to load" + path, e);
        }
    }

    public DataModelDesc dropModel(DataModelDesc desc) throws IOException {
        logger.info("Dropping model '" + desc.getName() + "'");
        ResourceStore store = this.getStore();
        if (desc != null) {
            store.deleteResource(desc.getResourcePath());
        }
        ProjectManager.getInstance(this.config).removeModelFromProjects(desc.getName());
        this.afterModelDropped(desc);
        return desc;
    }

    private void afterModelDropped(DataModelDesc desc) {
        this.removeModelCache(desc.getName());
    }

    public void removeModelCache(String modelName) {
        this.dataModelDescMap.remove(modelName);
    }

    public DataModelDesc createDataModelDesc(DataModelDesc desc, String projectName, String owner) throws IOException {
        String name = desc.getName();
        if (this.dataModelDescMap.containsKey(name)) {
            throw new IllegalArgumentException("DataModelDesc '" + name + "' already exists");
        }
        ProjectManager.getInstance(this.config).updateModelToProject(name, projectName);
        return this.saveDataModelDesc(desc);
    }

    public DataModelDesc updateDataModelDesc(DataModelDesc desc) throws IOException {
        String name = desc.getName();
        if (!this.dataModelDescMap.containsKey(name)) {
            throw new IllegalArgumentException("DataModelDesc '" + name + "' does not exist.");
        }
        return this.saveDataModelDesc(desc);
    }

    private DataModelDesc saveDataModelDesc(DataModelDesc dataModelDesc) throws IOException {
        dataModelDesc.init(this.getAllTablesMap());
        String path = dataModelDesc.getResourcePath();
        this.getStore().putResource(path, dataModelDesc, MODELDESC_SERIALIZER);
        this.dataModelDescMap.put(dataModelDesc.getName(), dataModelDesc);
        return dataModelDesc;
    }

    public void saveTableExd(String tableId, Map<String, String> tableExdProperties) throws IOException {
        if (tableId == null) {
            throw new IllegalArgumentException("tableId couldn't be null");
        }
        TableDesc srcTable = (TableDesc)this.srcTableMap.get(tableId);
        if (srcTable == null) {
            throw new IllegalArgumentException("Couldn't find Source Table with identifier: " + tableId);
        }
        String path = TableDesc.concatExdResourcePath(tableId);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JsonUtil.writeValueIndent(os, tableExdProperties);
        os.flush();
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        this.getStore().putResource(path, is, System.currentTimeMillis());
        os.close();
        ((InputStream)is).close();
        this.srcTableExdMap.put(tableId, tableExdProperties);
    }

    public void removeTableExd(String tableIdentity) throws IOException {
        String path = TableDesc.concatExdResourcePath(tableIdentity);
        this.getStore().deleteResource(path);
        this.srcTableExdMap.remove(tableIdentity);
    }

    public String appendDBName(String table) {
        if (table.indexOf(".") > 0) {
            return table;
        }
        Map<String, TableDesc> map = this.getAllTablesMap();
        int count = 0;
        String result = null;
        for (TableDesc t : map.values()) {
            if (!t.getName().equalsIgnoreCase(table)) continue;
            result = t.getIdentity();
            ++count;
        }
        if (count == 1) {
            return result;
        }
        if (count > 1) {
            logger.warn("There are more than 1 table named with '" + table + "' in different database; The program couldn't determine, randomly pick '" + result + "'");
        }
        return result;
    }
}

