/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.hllc;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kylin.measure.hllc.HyperLogLogPlusCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HLLDistinctCountAggFunc {
    private static final Logger logger = LoggerFactory.getLogger(HLLDistinctCountAggFunc.class);

    public static HyperLogLogPlusCounter init() {
        return null;
    }

    public static HyperLogLogPlusCounter initAdd(Object v) {
        if (v instanceof Long) {
            long l = (Long)v;
            return new FixedValueHLLCMockup(l);
        }
        HyperLogLogPlusCounter c = (HyperLogLogPlusCounter)v;
        return new HyperLogLogPlusCounter(c);
    }

    public static HyperLogLogPlusCounter add(HyperLogLogPlusCounter counter, Object v) {
        if (v instanceof Long) {
            long l = (Long)v;
            if (counter == null) {
                return new FixedValueHLLCMockup(l);
            }
            if (!(counter instanceof FixedValueHLLCMockup)) {
                throw new IllegalStateException("counter is not FixedValueHLLCMockup");
            }
            ((FixedValueHLLCMockup)counter).set(l);
            return counter;
        }
        HyperLogLogPlusCounter c = (HyperLogLogPlusCounter)v;
        if (counter == null) {
            return new HyperLogLogPlusCounter(c);
        }
        counter.merge(c);
        return counter;
    }

    public static HyperLogLogPlusCounter merge(HyperLogLogPlusCounter counter0, Object counter1) {
        return HLLDistinctCountAggFunc.add(counter0, counter1);
    }

    public static long result(HyperLogLogPlusCounter counter) {
        return counter == null ? 0L : counter.getCountEstimate();
    }

    private static class FixedValueHLLCMockup
    extends HyperLogLogPlusCounter {
        private Long value = null;

        FixedValueHLLCMockup(long value) {
            this.value = value;
        }

        public void set(long value) {
            if (this.value == null) {
                this.value = value;
            } else {
                long oldValue = Math.abs(this.value);
                long take = Math.max(oldValue, value);
                logger.warn("Error to aggregate holistic count distinct, old value " + oldValue + ", new value " + value + ", taking " + take);
                this.value = -take;
            }
        }

        @Override
        public void clear() {
            this.value = null;
        }

        @Override
        protected void add(long hash) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void merge(HyperLogLogPlusCounter another) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getCountEstimate() {
            return this.value;
        }

        @Override
        public void writeRegisters(ByteBuffer out) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readRegisters(ByteBuffer in) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.value ^ this.value >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FixedValueHLLCMockup other = (FixedValueHLLCMockup)obj;
            return this.value.equals(other.value);
        }
    }
}

