/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.dim;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimCountDistinctAggFunc {
    private static final Logger logger = LoggerFactory.getLogger(DimCountDistinctAggFunc.class);

    public static DimDistinctCounter init() {
        return null;
    }

    public static DimDistinctCounter initAdd(Object v) {
        DimDistinctCounter counter = new DimDistinctCounter();
        counter.add(v);
        return counter;
    }

    public static DimDistinctCounter add(DimDistinctCounter counter, Object v) {
        if (counter == null) {
            counter = new DimDistinctCounter();
        }
        counter.add(v);
        return counter;
    }

    public static DimDistinctCounter merge(DimDistinctCounter counter0, DimDistinctCounter counter1) {
        counter0.addAll(counter1);
        return counter0;
    }

    public static long result(DimDistinctCounter counter) {
        return counter == null ? 0L : counter.result();
    }

    public static class DimDistinctCounter {
        private final Set container = Sets.newHashSet();
        private final int MAX_LENGTH = KylinConfig.getInstanceFromEnv().getDimCountDistinctMaxCardinality();

        public void add(Object v) {
            if (this.container.size() >= this.MAX_LENGTH) {
                throw new RuntimeException("Cardinality of dimension exceeds the threshold: " + this.MAX_LENGTH);
            }
            this.container.add(v);
        }

        public void addAll(DimDistinctCounter counter) {
            if (this.container.size() + counter.container.size() >= this.MAX_LENGTH) {
                throw new RuntimeException("Cardinality of dimension exceeds the threshold: " + this.MAX_LENGTH);
            }
            this.container.addAll(counter.container);
        }

        public long result() {
            return this.container.size();
        }
    }
}

