/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class BitmapSerializer
extends DataTypeSerializer<BitmapCounter> {
    private ThreadLocal<BitmapCounter> current = new ThreadLocal();

    public BitmapSerializer(DataType type) {
    }

    @Override
    public void serialize(BitmapCounter value, ByteBuffer out) {
        try {
            value.writeRegisters(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private BitmapCounter current() {
        BitmapCounter counter = this.current.get();
        if (counter == null) {
            counter = new BitmapCounter();
            this.current.set(counter);
        }
        return counter;
    }

    @Override
    public BitmapCounter deserialize(ByteBuffer in) {
        BitmapCounter counter = this.current();
        try {
            counter.readRegisters(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return counter;
    }

    @Override
    public int peekLength(ByteBuffer in) {
        return this.current().peekLength(in);
    }

    @Override
    public int maxLength() {
        return 0x800000;
    }

    @Override
    public int getStorageBytesEstimate() {
        return this.current().getMemBytes();
    }
}

