/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.basic.BasicMeasureType;
import org.apache.kylin.measure.bitmap.BitmapMeasureType;
import org.apache.kylin.measure.dim.DimCountDistinctMeasureType;
import org.apache.kylin.measure.extendedcolumn.ExtendedColumnMeasureType;
import org.apache.kylin.measure.hllc.HLLCMeasureType;
import org.apache.kylin.measure.raw.RawMeasureType;
import org.apache.kylin.measure.topn.TopNMeasureType;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public abstract class MeasureTypeFactory<T> {
    private static Map<String, List<MeasureTypeFactory<?>>> factories = Maps.newHashMap();
    private static List<MeasureTypeFactory<?>> defaultFactory = Lists.newArrayListWithCapacity((int)2);

    public abstract MeasureType<T> createMeasureType(String var1, DataType var2);

    public abstract String getAggrFunctionName();

    public abstract String getAggrDataTypeName();

    public abstract Class<? extends DataTypeSerializer<T>> getAggrDataTypeSerializer();

    public static synchronized void init() {
        if (!factories.isEmpty()) {
            return;
        }
        ArrayList factoryInsts = Lists.newArrayList();
        factoryInsts.add(new HLLCMeasureType.Factory());
        factoryInsts.add(new BitmapMeasureType.Factory());
        factoryInsts.add(new TopNMeasureType.Factory());
        factoryInsts.add(new RawMeasureType.Factory());
        factoryInsts.add(new ExtendedColumnMeasureType.Factory());
        for (MeasureTypeFactory factory : factoryInsts) {
            String funcName = factory.getAggrFunctionName();
            if (!funcName.equals(funcName.toUpperCase())) {
                throw new IllegalArgumentException("Aggregation function name '" + funcName + "' must be in upper case");
            }
            String dataTypeName = factory.getAggrDataTypeName();
            if (!dataTypeName.equals(dataTypeName.toLowerCase())) {
                throw new IllegalArgumentException("Aggregation data type name '" + dataTypeName + "' must be in lower case");
            }
            Class serializer = factory.getAggrDataTypeSerializer();
            DataType.register(dataTypeName);
            DataTypeSerializer.register(dataTypeName, serializer);
            ArrayList list = factories.get(funcName);
            if (list == null) {
                list = Lists.newArrayListWithCapacity((int)2);
                factories.put(funcName, list);
            }
            list.add(factory);
        }
        defaultFactory.add(new BasicMeasureType.Factory());
    }

    public static MeasureType<?> create(String funcName, String dataType) {
        return MeasureTypeFactory.create(funcName, DataType.getType(dataType));
    }

    public static MeasureType<?> createNoRewriteFieldsMeasureType(String funcName, DataType dataType) {
        if (funcName.equalsIgnoreCase("COUNT_DISTINCT")) {
            return new DimCountDistinctMeasureType.DimCountDistinctMeasureTypeFactory().createMeasureType(funcName, dataType);
        }
        throw new UnsupportedOperationException("No measure type found.");
    }

    public static MeasureType<?> create(String funcName, DataType dataType) {
        List<MeasureTypeFactory<?>> factory = factories.get(funcName = funcName.toUpperCase());
        if (factory == null) {
            factory = defaultFactory;
        }
        if (dataType == null) {
            return new NeedRewriteOnlyMeasureType(funcName, factory);
        }
        if (factory.size() == 1) {
            return factory.get(0).createMeasureType(funcName, dataType);
        }
        for (MeasureTypeFactory<?> f : factory) {
            if (!f.getAggrDataTypeName().equals(dataType.getName())) continue;
            return f.createMeasureType(funcName, dataType);
        }
        throw new IllegalStateException();
    }

    static {
        MeasureTypeFactory.init();
    }

    private static class NeedRewriteOnlyMeasureType
    extends MeasureType {
        private Boolean needRewrite;

        public NeedRewriteOnlyMeasureType(String funcName, List<MeasureTypeFactory<?>> factory) {
            for (MeasureTypeFactory<?> f : factory) {
                boolean b = f.createMeasureType(funcName, null).needRewrite();
                if (this.needRewrite == null) {
                    this.needRewrite = b;
                    continue;
                }
                if (this.needRewrite == b) continue;
                throw new IllegalStateException("needRewrite() of factorys " + factory + " does not have consensus");
            }
        }

        public MeasureIngester newIngester() {
            throw new UnsupportedOperationException();
        }

        public MeasureAggregator newAggregator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean needRewrite() {
            return this.needRewrite;
        }

        public Class getRewriteCalciteAggrFunctionClass() {
            throw new UnsupportedOperationException();
        }
    }
}

