/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import com.google.common.base.Preconditions;

public final class ExecuteResult {
    private final State state;
    private final String output;

    public ExecuteResult(State state) {
        this(state, "");
    }

    public ExecuteResult(State state, String output) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state cannot be null");
        this.state = state;
        this.output = output;
    }

    public State state() {
        return this.state;
    }

    public boolean succeed() {
        return this.state == State.SUCCEED;
    }

    public String output() {
        return this.output;
    }

    public static enum State {
        SUCCEED,
        FAILED,
        ERROR,
        DISCARDED,
        STOPPED;

    }
}

