/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public enum ExecutableState {
    READY,
    RUNNING,
    ERROR,
    STOPPED,
    DISCARDED,
    SUCCEED;

    private static Multimap<ExecutableState, ExecutableState> VALID_STATE_TRANSFER;

    public boolean isFinalState() {
        return this == SUCCEED || this == DISCARDED;
    }

    public static boolean isValidStateTransfer(ExecutableState from, ExecutableState to) {
        return VALID_STATE_TRANSFER.containsEntry((Object)from, (Object)to);
    }

    static {
        VALID_STATE_TRANSFER = Multimaps.newSetMultimap((Map)Maps.newEnumMap(ExecutableState.class), (Supplier)new Supplier<Set<ExecutableState>>(){

            public Set<ExecutableState> get() {
                return new CopyOnWriteArraySet<ExecutableState>();
            }
        });
        VALID_STATE_TRANSFER.put((Object)READY, (Object)RUNNING);
        VALID_STATE_TRANSFER.put((Object)READY, (Object)ERROR);
        VALID_STATE_TRANSFER.put((Object)READY, (Object)DISCARDED);
        VALID_STATE_TRANSFER.put((Object)RUNNING, (Object)READY);
        VALID_STATE_TRANSFER.put((Object)RUNNING, (Object)SUCCEED);
        VALID_STATE_TRANSFER.put((Object)RUNNING, (Object)DISCARDED);
        VALID_STATE_TRANSFER.put((Object)RUNNING, (Object)ERROR);
        VALID_STATE_TRANSFER.put((Object)STOPPED, (Object)DISCARDED);
        VALID_STATE_TRANSFER.put((Object)STOPPED, (Object)READY);
        VALID_STATE_TRANSFER.put((Object)ERROR, (Object)DISCARDED);
        VALID_STATE_TRANSFER.put((Object)ERROR, (Object)READY);
    }
}

