/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ChainedExecutable;
import org.apache.kylin.job.execution.Executable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.manager.ExecutableManager;

public class DefaultChainedExecutable
extends AbstractExecutable
implements ChainedExecutable {
    private final List<AbstractExecutable> subTasks = Lists.newArrayList();
    protected final ExecutableManager jobService = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv());

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        List<AbstractExecutable> executables = this.getTasks();
        int size = executables.size();
        for (int i = 0; i < size; ++i) {
            Executable subTask = executables.get(i);
            if (!subTask.isRunnable()) continue;
            return subTask.execute(context);
        }
        return new ExecuteResult(ExecuteResult.State.SUCCEED, null);
    }

    @Override
    protected void onExecuteStart(ExecutableContext executableContext) {
        HashMap info = Maps.newHashMap();
        info.put("startTime", Long.toString(System.currentTimeMillis()));
        long startTime = this.getStartTime();
        if (startTime > 0L) {
            this.jobService.updateJobOutput(this.getId(), ExecutableState.RUNNING, null, null);
        } else {
            this.jobService.updateJobOutput(this.getId(), ExecutableState.RUNNING, info, null);
        }
    }

    @Override
    protected void onExecuteFinished(ExecuteResult result, ExecutableContext executableContext) {
        if (this.isDiscarded()) {
            this.setEndTime(System.currentTimeMillis());
            this.notifyUserStatusChange(executableContext, ExecutableState.DISCARDED);
        } else if (result.succeed()) {
            List<AbstractExecutable> jobs = this.getTasks();
            boolean allSucceed = true;
            boolean hasError = false;
            for (Executable executable : jobs) {
                ExecutableState status = executable.getStatus();
                if (status == ExecutableState.ERROR) {
                    hasError = true;
                }
                if (status == ExecutableState.SUCCEED) continue;
                allSucceed = false;
            }
            if (allSucceed) {
                this.setEndTime(System.currentTimeMillis());
                this.jobService.updateJobOutput(this.getId(), ExecutableState.SUCCEED, null, null);
                this.notifyUserStatusChange(executableContext, ExecutableState.SUCCEED);
            } else if (hasError) {
                this.setEndTime(System.currentTimeMillis());
                this.jobService.updateJobOutput(this.getId(), ExecutableState.ERROR, null, null);
                this.notifyUserStatusChange(executableContext, ExecutableState.ERROR);
            } else {
                this.jobService.updateJobOutput(this.getId(), ExecutableState.READY, null, null);
            }
        } else {
            this.setEndTime(System.currentTimeMillis());
            this.jobService.updateJobOutput(this.getId(), ExecutableState.ERROR, null, result.output());
            this.notifyUserStatusChange(executableContext, ExecutableState.ERROR);
        }
    }

    public List<AbstractExecutable> getTasks() {
        return this.subTasks;
    }

    @Override
    protected boolean needRetry() {
        return false;
    }

    public final AbstractExecutable getTaskByName(String name) {
        for (AbstractExecutable task : this.subTasks) {
            if (task.getName() == null || !task.getName().equalsIgnoreCase(name)) continue;
            return task;
        }
        return null;
    }

    @Override
    public void addTask(AbstractExecutable executable) {
        executable.setId(this.getId() + "-" + String.format("%02d", this.subTasks.size()));
        this.subTasks.add(executable);
    }
}

