/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.engine;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.OptionsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobEngineConfig {
    private static final Logger logger = LoggerFactory.getLogger(JobEngineConfig.class);
    public static final String HADOOP_JOB_CONF_FILENAME = "kylin_job_conf";
    public static final String HIVE_CONF_FILENAME = "kylin_hive_conf";
    public static final String DEFAUL_JOB_CONF_SUFFIX = "";
    public static final String IN_MEM_JOB_CONF_SUFFIX = "inmem";
    private final KylinConfig config;

    private static File getJobConfig(String fileName) {
        String path = System.getProperty("KYLIN_CONF");
        if (StringUtils.isNotEmpty((String)path)) {
            return new File(path, fileName);
        }
        path = KylinConfig.getKylinHome();
        if (StringUtils.isNotEmpty((String)path)) {
            return new File(path + File.separator + "conf", fileName);
        }
        return null;
    }

    private String getHadoopJobConfFilePath(String suffix, boolean appendSuffix) throws IOException {
        String hadoopJobConfFile = suffix != null && appendSuffix ? "kylin_job_conf_" + suffix.toLowerCase() + ".xml" : "kylin_job_conf.xml";
        File jobConfig = JobEngineConfig.getJobConfig(hadoopJobConfFile);
        if (jobConfig == null || !jobConfig.exists()) {
            logger.warn("fail to locate " + hadoopJobConfFile + ", trying to locate " + HADOOP_JOB_CONF_FILENAME + ".xml");
            jobConfig = JobEngineConfig.getJobConfig("kylin_job_conf.xml");
            if (jobConfig == null || !jobConfig.exists()) {
                logger.error("fail to locate kylin_job_conf.xml");
                throw new RuntimeException("fail to locate kylin_job_conf.xml");
            }
        }
        return OptionsHelper.convertToFileURL(jobConfig.getAbsolutePath());
    }

    public String getHadoopJobConfFilePath(String jobType) throws IOException {
        String path;
        String suffix = null;
        if (!StringUtils.isEmpty((String)jobType)) {
            suffix = jobType;
        }
        if (StringUtils.isEmpty((String)(path = this.getHadoopJobConfFilePath(suffix, true))) && StringUtils.isEmpty((String)(path = this.getHadoopJobConfFilePath(jobType, true))) && StringUtils.isEmpty((String)(path = this.getHadoopJobConfFilePath(jobType, false)))) {
            path = DEFAUL_JOB_CONF_SUFFIX;
        }
        logger.info("Chosen job conf is : " + path);
        return path;
    }

    public String getHiveConfFilePath() throws IOException {
        String hiveConfFile = "kylin_hive_conf.xml";
        File jobConfig = JobEngineConfig.getJobConfig(hiveConfFile);
        if (jobConfig == null || !jobConfig.exists()) {
            logger.error("fail to locate kylin_hive_conf.xml");
            throw new RuntimeException("fail to locate kylin_hive_conf.xml");
        }
        return OptionsHelper.convertToFileURL(jobConfig.getAbsolutePath());
    }

    public JobEngineConfig(KylinConfig config) {
        this.config = config;
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public String getHdfsWorkingDirectory() {
        return this.config.getHdfsWorkingDirectory();
    }

    public int getMaxConcurrentJobLimit() {
        return this.config.getMaxConcurrentJobLimit();
    }

    public String getTimeZone() {
        return this.config.getTimeZone();
    }

    public String[] getAdminDls() {
        return this.config.getAdminDls();
    }

    public long getJobStepTimeout() {
        return this.config.getJobStepTimeout();
    }

    public int getAsyncJobCheckInterval() {
        return this.config.getYarnStatusCheckIntervalSeconds();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobEngineConfig other = (JobEngineConfig)obj;
        return !(this.config == null ? other.config != null : !this.config.equals(other.config));
    }
}

