/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.dao;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.job.dao.ExecutableOutputPO;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.exception.PersistentException;
import org.apache.kylin.metadata.MetadataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableDao {
    private static final Serializer<ExecutablePO> JOB_SERIALIZER = new JsonSerializer<ExecutablePO>(ExecutablePO.class);
    private static final Serializer<ExecutableOutputPO> JOB_OUTPUT_SERIALIZER = new JsonSerializer<ExecutableOutputPO>(ExecutableOutputPO.class);
    private static final Logger logger = LoggerFactory.getLogger(ExecutableDao.class);
    private static final ConcurrentHashMap<KylinConfig, ExecutableDao> CACHE = new ConcurrentHashMap();
    private ResourceStore store;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutableDao getInstance(KylinConfig config) {
        ExecutableDao r = CACHE.get(config);
        if (r != null) return r;
        Class<ExecutableDao> clazz = ExecutableDao.class;
        synchronized (ExecutableDao.class) {
            r = CACHE.get(config);
            if (r != null) return r;
            r = new ExecutableDao(config);
            CACHE.put(config, r);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return r;
        }
    }

    private ExecutableDao(KylinConfig config) {
        logger.info("Using metadata url: " + config);
        this.store = MetadataManager.getInstance(config).getStore();
    }

    private String pathOfJob(ExecutablePO job) {
        return ExecutableDao.pathOfJob(job.getUuid());
    }

    public static String pathOfJob(String uuid) {
        return "/execute/" + uuid;
    }

    public static String pathOfJobOutput(String uuid) {
        return "/execute_output/" + uuid;
    }

    private ExecutablePO readJobResource(String path) throws IOException {
        return this.store.getResource(path, ExecutablePO.class, JOB_SERIALIZER);
    }

    private void writeJobResource(String path, ExecutablePO job) throws IOException {
        this.store.putResource(path, job, JOB_SERIALIZER);
    }

    private ExecutableOutputPO readJobOutputResource(String path) throws IOException {
        return this.store.getResource(path, ExecutableOutputPO.class, JOB_OUTPUT_SERIALIZER);
    }

    private long writeJobOutputResource(String path, ExecutableOutputPO output) throws IOException {
        return this.store.putResource(path, output, JOB_OUTPUT_SERIALIZER);
    }

    public List<ExecutableOutputPO> getJobOutputs() throws PersistentException {
        try {
            return this.store.getAllResources("/execute_output", ExecutableOutputPO.class, JOB_OUTPUT_SERIALIZER);
        }
        catch (IOException e) {
            logger.error("error get all Jobs:", (Throwable)e);
            throw new PersistentException(e);
        }
    }

    public List<ExecutableOutputPO> getJobOutputs(long timeStart, long timeEndExclusive) throws PersistentException {
        try {
            return this.store.getAllResources("/execute_output", timeStart, timeEndExclusive, ExecutableOutputPO.class, JOB_OUTPUT_SERIALIZER);
        }
        catch (IOException e) {
            logger.error("error get all Jobs:", (Throwable)e);
            throw new PersistentException(e);
        }
    }

    public List<ExecutablePO> getJobs() throws PersistentException {
        try {
            return this.store.getAllResources("/execute", ExecutablePO.class, JOB_SERIALIZER);
        }
        catch (IOException e) {
            logger.error("error get all Jobs:", (Throwable)e);
            throw new PersistentException(e);
        }
    }

    public List<ExecutablePO> getJobs(long timeStart, long timeEndExclusive) throws PersistentException {
        try {
            return this.store.getAllResources("/execute", timeStart, timeEndExclusive, ExecutablePO.class, JOB_SERIALIZER);
        }
        catch (IOException e) {
            logger.error("error get all Jobs:", (Throwable)e);
            throw new PersistentException(e);
        }
    }

    public List<String> getJobIds() throws PersistentException {
        try {
            NavigableSet<String> resources = this.store.listResources("/execute");
            if (resources == null) {
                return Collections.emptyList();
            }
            ArrayList result = Lists.newArrayListWithExpectedSize((int)resources.size());
            for (String path : resources) {
                result.add(path.substring(path.lastIndexOf("/") + 1));
            }
            return result;
        }
        catch (IOException e) {
            logger.error("error get all Jobs:", (Throwable)e);
            throw new PersistentException(e);
        }
    }

    public ExecutablePO getJob(String uuid) throws PersistentException {
        try {
            return this.readJobResource(ExecutableDao.pathOfJob(uuid));
        }
        catch (IOException e) {
            logger.error("error get job:" + uuid, (Throwable)e);
            throw new PersistentException(e);
        }
    }

    public ExecutablePO addJob(ExecutablePO job) throws PersistentException {
        try {
            if (this.getJob(job.getUuid()) != null) {
                throw new IllegalArgumentException("job id:" + job.getUuid() + " already exists");
            }
            this.writeJobResource(this.pathOfJob(job), job);
            return job;
        }
        catch (IOException e) {
            logger.error("error save job:" + job.getUuid(), (Throwable)e);
            throw new PersistentException(e);
        }
    }

    public void deleteJob(String uuid) throws PersistentException {
        try {
            this.store.deleteResource(ExecutableDao.pathOfJob(uuid));
        }
        catch (IOException e) {
            logger.error("error delete job:" + uuid, (Throwable)e);
            throw new PersistentException(e);
        }
    }

    public ExecutableOutputPO getJobOutput(String uuid) throws PersistentException {
        try {
            ExecutableOutputPO result = this.readJobOutputResource(ExecutableDao.pathOfJobOutput(uuid));
            if (result == null) {
                result = new ExecutableOutputPO();
                result.setUuid(uuid);
                return result;
            }
            return result;
        }
        catch (IOException e) {
            logger.error("error get job output id:" + uuid, (Throwable)e);
            throw new PersistentException(e);
        }
    }

    public void addJobOutput(ExecutableOutputPO output) throws PersistentException {
        try {
            output.setLastModified(0L);
            this.writeJobOutputResource(ExecutableDao.pathOfJobOutput(output.getUuid()), output);
        }
        catch (IOException e) {
            logger.error("error update job output id:" + output.getUuid(), (Throwable)e);
            throw new PersistentException(e);
        }
    }

    public void updateJobOutput(ExecutableOutputPO output) throws PersistentException {
        try {
            long ts = this.writeJobOutputResource(ExecutableDao.pathOfJobOutput(output.getUuid()), output);
            output.setLastModified(ts);
        }
        catch (IOException e) {
            logger.error("error update job output id:" + output.getUuid(), (Throwable)e);
            throw new PersistentException(e);
        }
    }

    public void deleteJobOutput(String uuid) throws PersistentException {
        try {
            this.store.deleteResource(ExecutableDao.pathOfJobOutput(uuid));
        }
        catch (IOException e) {
            logger.error("error delete job:" + uuid, (Throwable)e);
            throw new PersistentException(e);
        }
    }
}

