/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.model;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.kylin.invertedindex.model.IIDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.IntermediateColumnDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class IIJoinedFlatTableDesc
implements IJoinedFlatTableDesc {
    private IIDesc iiDesc;
    private String tableName;
    private List<IntermediateColumnDesc> columnList = Lists.newArrayList();

    public IIJoinedFlatTableDesc(IIDesc iiDesc) {
        this.iiDesc = iiDesc;
        this.parseIIDesc();
    }

    private void parseIIDesc() {
        this.tableName = "kylin_intermediate_ii_" + this.iiDesc.getName();
        int columnIndex = 0;
        for (TblColRef col : this.iiDesc.listAllColumns()) {
            this.columnList.add(new IntermediateColumnDesc(String.valueOf(columnIndex), col));
            ++columnIndex;
        }
    }

    @Override
    public String getTableName() {
        return this.tableName + "_" + "II_Flat";
    }

    @Override
    public List<IntermediateColumnDesc> getColumnList() {
        return this.columnList;
    }

    @Override
    public DataModelDesc getDataModel() {
        return this.iiDesc.getModel();
    }

    @Override
    public DataModelDesc.RealizationCapacity getCapacity() {
        return DataModelDesc.RealizationCapacity.SMALL;
    }
}

