/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.measure;

import java.nio.ByteBuffer;
import org.apache.kylin.invertedindex.measure.FixedLenMeasureCodec;
import org.apache.kylin.measure.hllc.HyperLogLogPlusCounter;
import org.apache.kylin.metadata.datatype.DataType;

public class FixedHLLCodec
extends FixedLenMeasureCodec<HyperLogLogPlusCounter> {
    private DataType type;
    private int presision;
    private HyperLogLogPlusCounter current;

    public FixedHLLCodec(DataType type) {
        this.type = type;
        this.presision = type.getPrecision();
        this.current = new HyperLogLogPlusCounter(this.presision);
    }

    @Override
    public int getLength() {
        return 1 << this.presision;
    }

    @Override
    public DataType getDataType() {
        return this.type;
    }

    @Override
    public HyperLogLogPlusCounter valueOf(String value) {
        this.current.clear();
        if (value != null) {
            this.current.add(value.getBytes());
        }
        return this.current;
    }

    @Override
    public Object getValue() {
        return this.current;
    }

    @Override
    public HyperLogLogPlusCounter read(byte[] buf, int offset) {
        this.current.readRegistersArray(ByteBuffer.wrap(buf, offset, buf.length - offset));
        return this.current;
    }

    @Override
    public void write(HyperLogLogPlusCounter v, byte[] buf, int offset) {
        v.writeRegistersArray(ByteBuffer.wrap(buf, offset, buf.length - offset));
    }

    @Override
    public HyperLogLogPlusCounter read(ByteBuffer buffer) {
        this.current.readRegistersArray(buffer);
        return this.current;
    }
}

