/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.index;

import java.util.List;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.invertedindex.IISegment;
import org.apache.kylin.invertedindex.index.TableRecord;
import org.apache.kylin.invertedindex.index.TableRecordInfoDigest;
import org.apache.kylin.invertedindex.measure.FixedLenMeasureCodec;
import org.apache.kylin.invertedindex.model.IIDesc;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.TblColRef;

public class TableRecordInfo {
    final IIDesc desc;
    final TableRecordInfoDigest digest;
    final Dictionary<?>[] dictionaries;

    public TableRecordInfo(IISegment iiSegment) {
        this(iiSegment.getIIDesc());
    }

    public TableRecordInfo(IIDesc desc) {
        this(desc, new Dictionary[desc.listAllColumns().size()]);
    }

    public TableRecordInfo(IIDesc desc, Dictionary<?>[] dictionaries) {
        this.desc = desc;
        this.dictionaries = dictionaries;
        this.digest = this.createDigest(desc, dictionaries);
    }

    public TableRecordInfoDigest getDigest() {
        return this.digest;
    }

    private TableRecordInfoDigest createDigest(IIDesc desc, Dictionary<?>[] dictionaryMap) {
        List<TblColRef> tblColRefs = desc.listAllColumns();
        int nColumns = tblColRefs.size();
        boolean[] isMetric = new boolean[nColumns];
        int[] lengths = new int[nColumns];
        int[] dictMaxIds = new int[nColumns];
        String[] dataTypes = new String[nColumns];
        for (int i = 0; i < nColumns; ++i) {
            TblColRef tblColRef = tblColRefs.get(i);
            isMetric[i] = desc.isMetricsCol(i);
            dataTypes[i] = tblColRef.getDatatype();
            if (isMetric[i]) {
                lengths[i] = FixedLenMeasureCodec.get(DataType.getType(tblColRef.getColumnDesc().getDatatype())).getLength();
                continue;
            }
            if (Array.isEmpty(dictionaryMap)) {
                DataType dataType = DataType.getType(tblColRef.getColumnDesc().getDatatype());
                if (dataType.isNumberFamily()) {
                    lengths[i] = 16;
                } else if (dataType.isStringFamily()) {
                    lengths[i] = 256;
                } else if (dataType.isDateTimeFamily()) {
                    lengths[i] = 19;
                } else {
                    throw new RuntimeException("invalid data type:" + dataType);
                }
                dictMaxIds[i] = Integer.MAX_VALUE;
                continue;
            }
            Dictionary<?> dictionary = dictionaryMap[i];
            lengths[i] = dictionary.getSizeOfId();
            dictMaxIds[i] = dictionary.getMaxId();
        }
        int pos = 0;
        int[] offsets = new int[nColumns];
        for (int i = 0; i < nColumns; ++i) {
            offsets[i] = pos;
            pos += lengths[i];
        }
        int byteFormLen = pos;
        return new TableRecordInfoDigest(nColumns, byteFormLen, offsets, dictMaxIds, lengths, isMetric, dataTypes);
    }

    public TableRecord createTableRecord() {
        return new TableRecord(this.digest.createTableRecordBytes(), this);
    }

    public final IIDesc getDescriptor() {
        return this.desc;
    }

    public final List<TblColRef> getColumns() {
        return this.desc.listAllColumns();
    }

    public int findColumn(TblColRef col) {
        return this.desc.findColumn(col);
    }

    public int findFactTableColumn(String columnName) {
        if (columnName == null) {
            return -1;
        }
        for (int i = 0; i < this.getColumns().size(); ++i) {
            TblColRef tblColRef = this.getColumns().get(i);
            if (!tblColRef.isSameAs(this.desc.getFactTableName(), columnName)) continue;
            return i;
        }
        return -1;
    }

    public Dictionary<String> dict(int col) {
        return this.dictionaries[col];
    }

    public int getTimestampColumn() {
        return this.desc.getTimestampColumn();
    }
}

