/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.index;

import java.util.Arrays;
import org.apache.commons.lang.ObjectUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.ShardingHash;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.invertedindex.index.RawTableRecord;
import org.apache.kylin.invertedindex.index.TableRecordInfo;
import org.apache.kylin.metadata.datatype.LongMutable;

public class TableRecord
implements Cloneable {
    private TableRecordInfo info;
    private RawTableRecord rawRecord;
    public static final byte ROWKEY_PLACE_HOLDER_BYTE = 9;

    public TableRecord(RawTableRecord rawRecord, TableRecordInfo info) {
        this.info = info;
        this.rawRecord = rawRecord;
    }

    public TableRecord(TableRecord another) {
        this.info = another.info;
        this.rawRecord = (RawTableRecord)another.rawRecord.clone();
    }

    public TableRecordInfo getInfo() {
        return this.info;
    }

    public Object clone() {
        return new TableRecord(this);
    }

    public void reset() {
        this.rawRecord.reset();
    }

    public byte[] getBytes() {
        return this.rawRecord.getBytes();
    }

    public void setBytes(byte[] bytes, int offset, int length) {
        this.rawRecord.setBytes(bytes, offset, length);
    }

    public long getTimestamp() {
        String str = this.getValueString(this.info.getTimestampColumn());
        return DateFormat.stringToMillis(str);
    }

    public int length(int col) {
        return this.rawRecord.length(col);
    }

    public void setValueStringWithoutDictionary(int col, String value) {
        byte[] src;
        int offset = this.info.digest.offset(col);
        int length = this.info.digest.length(col);
        if (length >= (src = value.getBytes()).length) {
            byte[] dst = this.rawRecord.getBytes();
            System.arraycopy(src, 0, dst, offset, src.length);
            Arrays.fill(dst, offset + src.length, offset + length, (byte)9);
        } else {
            byte[] dst = this.rawRecord.getBytes();
            System.arraycopy(src, 0, dst, offset, length);
        }
    }

    public String getValueStringWithoutDictionary(int col) {
        int i;
        int offset = this.info.digest.offset(col);
        int length = this.info.digest.length(col);
        byte[] bytes = this.rawRecord.getBytes();
        for (i = 0; i < length && bytes[offset + i] != 9; ++i) {
        }
        return new String(bytes, offset, i);
    }

    public void setValueString(int col, String value) {
        if (this.rawRecord.isMetric(col)) {
            LongMutable v = this.rawRecord.codec(col).valueOf(value);
            this.setValueMetrics(col, v);
        } else {
            Dictionary<String> dict = this.info.dict(col);
            if (dict != null) {
                int id = dict.getIdFromValue(value);
                this.rawRecord.setValueID(col, id);
            } else {
                this.setValueStringWithoutDictionary(col, value);
            }
        }
    }

    public String getValueString(int col) {
        if (this.rawRecord.isMetric(col)) {
            return this.getValueMetric(col);
        }
        Dictionary<String> dict = this.info.dict(col);
        if (dict != null) {
            return dict.getValueFromId(this.rawRecord.getValueID(col));
        }
        return this.getValueStringWithoutDictionary(col);
    }

    public void getValueBytes(int col, ImmutableBytesWritable bytes) {
        this.rawRecord.getValueBytes(col, bytes);
    }

    private void setValueMetrics(int col, LongMutable value) {
        this.rawRecord.setValueMetrics(col, value);
    }

    private String getValueMetric(int col) {
        return this.rawRecord.getValueMetric(col);
    }

    public short getShard() {
        int timestampID = this.rawRecord.getValueID(this.info.getTimestampColumn());
        return ShardingHash.getShard(timestampID, (int)this.info.getDescriptor().getSharding());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        for (int col = 0; col < this.rawRecord.getColumnCount(); ++col) {
            if (col > 0) {
                buf.append(",");
            }
            buf.append(this.getValueString(col));
        }
        buf.append("]");
        return buf.toString();
    }

    public int hashCode() {
        if (this.rawRecord != null) {
            return this.rawRecord.hashCode();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableRecord other = (TableRecord)obj;
        return ObjectUtils.equals((Object)other.rawRecord, (Object)this.rawRecord);
    }
}

