/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.index;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.invertedindex.index.IncrementalSliceMaker;
import org.apache.kylin.invertedindex.index.Slice;
import org.apache.kylin.invertedindex.index.TableRecord;
import org.apache.kylin.invertedindex.index.TableRecordInfo;

public class ShardingSliceBuilder {
    IncrementalSliceMaker[] builders;

    public ShardingSliceBuilder(TableRecordInfo info) {
        short sharding = info.getDescriptor().getSharding();
        this.builders = new IncrementalSliceMaker[sharding];
        for (short i = 0; i < sharding; i = (short)(i + 1)) {
            this.builders[i] = new IncrementalSliceMaker(info, i);
        }
    }

    public Slice append(TableRecord rec) {
        short shard = rec.getShard();
        return this.builders[shard].append(rec);
    }

    public List<Slice> close() {
        ArrayList result = Lists.newArrayList();
        for (IncrementalSliceMaker builder : this.builders) {
            Slice slice = builder.close();
            if (slice == null) continue;
            result.add(slice);
        }
        return result;
    }
}

