/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.index;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.kylin.invertedindex.index.ColumnValueContainer;
import org.apache.kylin.invertedindex.index.CompressedValueContainer;
import org.apache.kylin.invertedindex.index.Slice;
import org.apache.kylin.invertedindex.index.TableRecord;
import org.apache.kylin.invertedindex.index.TableRecordInfo;

public class IncrementalSliceMaker {
    TableRecordInfo info;
    private int nColumns;
    int nRecordsCap;
    short shard;
    long sliceTimestamp;
    int nRecords;
    private ColumnValueContainer[] containers;
    transient ImmutableBytesWritable temp = new ImmutableBytesWritable();

    public IncrementalSliceMaker(TableRecordInfo info, short shard) {
        this.info = info;
        this.nColumns = info.getDigest().getColumnCount();
        this.nRecordsCap = Math.max(1, info.getDescriptor().getSliceSize());
        this.shard = shard;
        this.sliceTimestamp = Long.MIN_VALUE;
        this.nRecords = 0;
        this.containers = null;
        this.doneSlice();
    }

    private Slice doneSlice() {
        Slice r = null;
        if (this.nRecords > 0) {
            for (int i = 0; i < this.nColumns; ++i) {
                this.containers[i].closeForChange();
            }
            r = new Slice(this.info.getDigest(), this.shard, this.sliceTimestamp, this.containers);
        }
        this.nRecords = 0;
        this.containers = new ColumnValueContainer[this.nColumns];
        for (int i : this.info.getDescriptor().getValueColumns()) {
            this.containers[i] = new CompressedValueContainer(this.info.getDigest(), i, this.nRecordsCap);
        }
        for (int i : this.info.getDescriptor().getMetricsColumns()) {
            this.containers[i] = new CompressedValueContainer(this.info.getDigest(), i, this.nRecordsCap);
        }
        return r;
    }

    public Slice append(TableRecord rec) {
        if (rec.getShard() != this.shard) {
            throw new IllegalStateException();
        }
        Slice doneSlice = null;
        if (this.isFull()) {
            doneSlice = this.doneSlice();
        }
        if (this.nRecords == 0) {
            this.sliceTimestamp = this.increaseSliceTimestamp(rec.getTimestamp());
        }
        ++this.nRecords;
        for (int i = 0; i < this.nColumns; ++i) {
            rec.getValueBytes(i, this.temp);
            this.containers[i].append(this.temp);
        }
        return doneSlice;
    }

    private long increaseSliceTimestamp(long timestamp) {
        if (timestamp < this.sliceTimestamp) {
            throw new IllegalStateException();
        }
        if (timestamp == this.sliceTimestamp) {
            return ++timestamp;
        }
        return timestamp;
    }

    public Slice close() {
        Slice doneSlice = this.doneSlice();
        this.sliceTimestamp = Long.MIN_VALUE;
        this.nRecords = 0;
        return doneSlice;
    }

    private boolean isFull() {
        return this.nRecords >= this.nRecordsCap;
    }
}

