/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.index;

import com.ning.compress.lzf.LZFDecoder;
import com.ning.compress.lzf.LZFEncoder;
import it.uniroma3.mat.extendedset.intset.ConciseSet;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.invertedindex.index.ColumnValueContainer;
import org.apache.kylin.invertedindex.index.TableRecordInfoDigest;

public class CompressedValueContainer
implements ColumnValueContainer {
    int valueLen;
    int nValues;
    int cap;
    int size;
    byte[] uncompressed;
    byte[] compressed;

    public CompressedValueContainer(TableRecordInfoDigest digest, int col, int cap) {
        this(digest.length(col), digest.getMaxID(col) + 1, cap);
    }

    public CompressedValueContainer(int valueLen, int nValues, int cap) {
        this.valueLen = valueLen;
        this.nValues = nValues;
        this.cap = cap;
        this.size = 0;
        this.uncompressed = null;
        this.compressed = null;
    }

    @Override
    public void append(ImmutableBytesWritable valueBytes) {
        this.checkUpdateMode();
        System.arraycopy(valueBytes.get(), valueBytes.getOffset(), this.uncompressed, this.valueLen * this.size, this.valueLen);
        ++this.size;
    }

    @Override
    public void getValueAt(int i, ImmutableBytesWritable valueBytes) {
        valueBytes.set(this.uncompressed, this.valueLen * i, this.valueLen);
    }

    @Override
    public ConciseSet getBitMap(Integer startId, Integer endId) {
        ConciseSet ret = new ConciseSet();
        int nullId = Dictionary.NULL_ID[this.valueLen];
        if (startId == null && endId == null) {
            for (int i = 0; i < this.size; ++i) {
                int valueID = BytesUtil.readUnsigned(this.uncompressed, i * this.valueLen, this.valueLen);
                if (nullId != valueID) continue;
                ret.add(i);
            }
            return ret;
        }
        for (int i = 0; i < this.size; ++i) {
            int valueID = BytesUtil.readUnsigned(this.uncompressed, i * this.valueLen, this.valueLen);
            if (valueID == nullId || startId != null && valueID < startId || endId != null && valueID > endId) continue;
            ret.add(i);
        }
        return ret;
    }

    @Override
    public int getMaxValueId() {
        return this.nValues - 1;
    }

    private void checkUpdateMode() {
        if (this.isClosedForChange()) {
            throw new IllegalArgumentException();
        }
        if (this.uncompressed == null) {
            this.uncompressed = new byte[this.valueLen * this.cap];
        }
    }

    private boolean isClosedForChange() {
        return this.compressed != null;
    }

    @Override
    public void closeForChange() {
        this.checkUpdateMode();
        try {
            this.compressed = LZFEncoder.encode((byte[])this.uncompressed, (int)0, (int)(this.valueLen * this.size));
        }
        catch (Exception e) {
            throw new RuntimeException("LZF encode failure", e);
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public ImmutableBytesWritable toBytes() {
        if (!this.isClosedForChange()) {
            this.closeForChange();
        }
        return new ImmutableBytesWritable(this.compressed);
    }

    public void fromBytes(ImmutableBytesWritable bytes) {
        try {
            this.uncompressed = LZFDecoder.decode((byte[])bytes.get(), (int)bytes.getOffset(), (int)bytes.getLength());
        }
        catch (IOException e) {
            throw new RuntimeException("LZF decode failure", e);
        }
        this.size = this.cap = this.uncompressed.length / this.valueLen;
        this.compressed = BytesUtil.EMPTY_BYTE_ARRAY;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.size;
        result = 31 * result + this.valueLen;
        result = 31 * result + Arrays.hashCode(this.uncompressed);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompressedValueContainer other = (CompressedValueContainer)obj;
        if (this.size != other.size) {
            return false;
        }
        if (this.valueLen != other.valueLen) {
            return false;
        }
        return Bytes.equals(this.uncompressed, 0, this.size * this.valueLen, this.uncompressed, 0, this.size * this.valueLen);
    }
}

