/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.invertedindex.index.TableRecordInfo;
import org.apache.kylin.invertedindex.model.IIDesc;
import org.apache.kylin.invertedindex.model.IIJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationSegment;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class IISegment
implements Comparable<IISegment>,
IRealizationSegment {
    @JsonBackReference
    private IIInstance iiInstance;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="storage_location_identifier")
    private String storageLocationIdentifier;
    @JsonProperty(value="date_range_start")
    private long dateRangeStart;
    @JsonProperty(value="date_range_end")
    private long dateRangeEnd;
    @JsonProperty(value="status")
    private SegmentStatusEnum status;
    @JsonProperty(value="size_kb")
    private long sizeKB;
    @JsonProperty(value="input_records")
    private long inputRecords;
    @JsonProperty(value="input_records_size")
    private long inputRecordsSize;
    @JsonProperty(value="last_build_time")
    private long lastBuildTime;
    @JsonProperty(value="last_build_job_id")
    private String lastBuildJobID;
    @JsonProperty(value="create_time_utc")
    private long createTimeUTC;
    @JsonProperty(value="binary_signature")
    private String binarySignature;
    private transient TableRecordInfo tableRecordInfo;

    public static String getSegmentName(long startDate, long endDate) {
        if (startDate == 0L && endDate == 0L) {
            return "FULL_BUILD";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(startDate) + "_" + dateFormat.format(endDate);
    }

    public IIDesc getIIDesc() {
        return this.getIIInstance().getDescriptor();
    }

    @Override
    public KylinConfig getConfig() {
        return this.iiInstance.getConfig();
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String id) {
        this.uuid = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getDateRangeStart() {
        return this.dateRangeStart;
    }

    public void setDateRangeStart(long dateRangeStart) {
        this.dateRangeStart = dateRangeStart;
    }

    public long getDateRangeEnd() {
        return this.dateRangeEnd;
    }

    public void setDateRangeEnd(long dateRangeEnd) {
        this.dateRangeEnd = dateRangeEnd;
    }

    public SegmentStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(SegmentStatusEnum status) {
        this.status = status;
    }

    public long getSizeKB() {
        return this.sizeKB;
    }

    public void setSizeKB(long sizeKB) {
        this.sizeKB = sizeKB;
    }

    public long getInputRecords() {
        return this.inputRecords;
    }

    public void setInputRecords(long inputRecords) {
        this.inputRecords = inputRecords;
    }

    public long getInputRecordsSize() {
        return this.inputRecordsSize;
    }

    public void setInputRecordsSize(long inputRecordsSize) {
        this.inputRecordsSize = inputRecordsSize;
    }

    public long getLastBuildTime() {
        return this.lastBuildTime;
    }

    public void setLastBuildTime(long lastBuildTime) {
        this.lastBuildTime = lastBuildTime;
    }

    public String getLastBuildJobID() {
        return this.lastBuildJobID;
    }

    public void setLastBuildJobID(String lastBuildJobID) {
        this.lastBuildJobID = lastBuildJobID;
    }

    public String getBinarySignature() {
        return this.binarySignature;
    }

    public void setBinarySignature(String binarySignature) {
        this.binarySignature = binarySignature;
    }

    public IIInstance getIIInstance() {
        return this.iiInstance;
    }

    public void setIIInstance(IIInstance iiInstance) {
        this.iiInstance = iiInstance;
    }

    @Override
    public String getStorageLocationIdentifier() {
        return this.storageLocationIdentifier;
    }

    public void setStorageLocationIdentifier(String storageLocationIdentifier) {
        this.storageLocationIdentifier = storageLocationIdentifier;
    }

    @Override
    public int compareTo(IISegment other) {
        if (this.dateRangeEnd < other.dateRangeEnd) {
            return -1;
        }
        if (this.dateRangeEnd > other.dateRangeEnd) {
            return 1;
        }
        return 0;
    }

    private TableRecordInfo getTableRecordInfo() {
        if (this.tableRecordInfo == null) {
            this.tableRecordInfo = new TableRecordInfo(this);
        }
        return this.tableRecordInfo;
    }

    public List<TblColRef> getColumns() {
        return this.getTableRecordInfo().getColumns();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("uuid", (Object)this.uuid).add("create_time_utc:", this.createTimeUTC).add("name", (Object)this.name).add("last_build_job_id", (Object)this.lastBuildJobID).add("status", (Object)this.status).toString();
    }

    public long getCreateTimeUTC() {
        return this.createTimeUTC;
    }

    public void setCreateTimeUTC(long createTimeUTC) {
        this.createTimeUTC = createTimeUTC;
    }

    @Override
    public int getEngineType() {
        return 0;
    }

    @Override
    public int getSourceType() {
        return 0;
    }

    @Override
    public int getStorageType() {
        return 0;
    }

    @Override
    public IRealization getRealization() {
        return this.iiInstance;
    }

    @Override
    public IJoinedFlatTableDesc getJoinedFlatTableDesc() {
        return new IIJoinedFlatTableDesc(this.getIIDesc());
    }
}

