/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.restclient.Broadcaster;
import org.apache.kylin.common.restclient.CaseInsensitiveStringCache;
import org.apache.kylin.invertedindex.IIDescManager;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.invertedindex.IISegment;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationProvider;
import org.apache.kylin.metadata.realization.RealizationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IIManager
implements IRealizationProvider {
    private static String ALPHA_NUM = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static int HBASE_TABLE_LENGTH = 10;
    private static final Serializer<IIInstance> II_SERIALIZER = new JsonSerializer<IIInstance>(IIInstance.class);
    private static final Logger logger = LoggerFactory.getLogger(IIManager.class);
    private static final ConcurrentHashMap<KylinConfig, IIManager> CACHE = new ConcurrentHashMap();
    private KylinConfig config;
    private CaseInsensitiveStringCache<IIInstance> iiMap;
    private Multimap<String, String> usedStorageLocation = HashMultimap.create();

    public static IIManager getInstance(KylinConfig config) {
        IIManager r = CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<IIManager> clazz = IIManager.class;
        synchronized (IIManager.class) {
            r = CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new IIManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one singleton exist");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init IIManager from " + config, e);
            }
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    private IIManager(KylinConfig config) throws IOException {
        logger.info("Initializing IIManager with config " + config);
        this.config = config;
        this.iiMap = new CaseInsensitiveStringCache(config, Broadcaster.TYPE.INVERTED_INDEX);
        this.loadAllIIInstance();
    }

    public List<IIInstance> listAllIIs() {
        return new ArrayList<IIInstance>(this.iiMap.values());
    }

    public IIInstance getII(String iiName) {
        return (IIInstance)this.iiMap.get(iiName);
    }

    public List<IIInstance> getIIsByDesc(String descName) {
        List<IIInstance> list = this.listAllIIs();
        ArrayList<IIInstance> result = new ArrayList<IIInstance>();
        for (IIInstance ci : list) {
            if (!descName.equalsIgnoreCase(ci.getDescName())) continue;
            result.add(ci);
        }
        return result;
    }

    public IIInstance createII(IIInstance ii) throws IOException {
        if (this.getII(ii.getName()) != null) {
            throw new IllegalArgumentException("The II name '" + ii.getName() + "' already exists.");
        }
        this.updateII(ii);
        String projectName = "DEFAULT";
        ProjectManager.getInstance(this.config).moveRealizationToProject(RealizationType.INVERTED_INDEX, ii.getName(), projectName, ii.getOwner());
        return ii;
    }

    public void reloadIILocal(String iiName) {
        try {
            this.reloadIILocalAt(IIInstance.concatResourcePath(iiName));
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public IIInstance dropII(String iiName, boolean deleteDesc) throws IOException {
        logger.info("Dropping II '" + iiName + "'");
        IIInstance ii = this.getII(iiName);
        if (deleteDesc && ii.getDescriptor() != null) {
            IIDescManager.getInstance(this.config).removeIIDesc(ii.getDescriptor());
        }
        this.removeII(ii);
        ProjectManager.getInstance(this.config).removeRealizationsFromProjects(RealizationType.INVERTED_INDEX, iiName);
        return ii;
    }

    private void removeII(IIInstance ii) throws IOException {
        this.getStore().deleteResource(ii.getResourcePath());
        this.iiMap.remove(ii.getName());
    }

    public void removeIILocal(String name) {
        this.iiMap.removeLocal(name);
        this.usedStorageLocation.removeAll((Object)name.toUpperCase());
    }

    public void updateII(IIInstance ii) throws IOException {
        logger.info("Updating II instance : " + ii.getName());
        this.getStore().putResource(ii.getResourcePath(), ii, II_SERIALIZER);
        this.iiMap.put(ii.getName(), ii);
        ProjectManager.getInstance(KylinConfig.getInstanceFromEnv()).clearL2Cache();
    }

    public IISegment buildSegment(IIInstance IIInstance2, long startDate, long endDate) {
        IISegment segment = new IISegment();
        String incrementalSegName = IISegment.getSegmentName(startDate, endDate);
        segment.setUuid(UUID.randomUUID().toString());
        segment.setName(incrementalSegName);
        segment.setCreateTimeUTC(System.currentTimeMillis());
        segment.setDateRangeStart(startDate);
        segment.setDateRangeEnd(endDate);
        segment.setStatus(SegmentStatusEnum.NEW);
        segment.setStorageLocationIdentifier(this.generateStorageLocation());
        segment.setIIInstance(IIInstance2);
        return segment;
    }

    private String generateStorageLocation() {
        StringBuilder sb;
        do {
            sb = new StringBuilder("KYLIN_II_");
            for (int i = 0; i < HBASE_TABLE_LENGTH; ++i) {
                int idx = (int)(Math.random() * (double)ALPHA_NUM.length());
                sb.append(ALPHA_NUM.charAt(idx));
            }
        } while (this.usedStorageLocation.containsValue((Object)sb.toString()));
        return sb.toString();
    }

    private void loadAllIIInstance() throws IOException {
        ResourceStore store = this.getStore();
        List<String> paths = store.collectResourceRecursively("/invertedindex", ".json");
        logger.debug("Loading II from folder " + store.getReadableResourcePath("/invertedindex"));
        for (String path : paths) {
            this.reloadIILocalAt(path);
        }
        logger.debug("Loaded " + paths.size() + " II(s)");
    }

    private synchronized IIInstance reloadIILocalAt(String path) throws IOException {
        ResourceStore store = this.getStore();
        logger.debug("Loading IIInstance " + store.getReadableResourcePath(path));
        IIInstance ii = null;
        try {
            ii = store.getResource(path, IIInstance.class, II_SERIALIZER);
            ii.setConfig(this.config);
            if (StringUtils.isBlank((CharSequence)ii.getName())) {
                throw new IllegalStateException("IIInstance name must not be blank");
            }
            this.iiMap.putLocal(ii.getName(), ii);
            for (IISegment segment : ii.getSegments()) {
                this.usedStorageLocation.put((Object)ii.getName().toUpperCase(), (Object)segment.getStorageLocationIdentifier());
            }
            return ii;
        }
        catch (Exception e) {
            logger.error("Error during load ii instance " + path, (Throwable)e);
            return null;
        }
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    @Override
    public RealizationType getRealizationType() {
        return RealizationType.INVERTED_INDEX;
    }

    @Override
    public IRealization getRealization(String name) {
        return this.getII(name);
    }
}

