/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.invertedindex.IICapabilityChecker;
import org.apache.kylin.invertedindex.IIDescManager;
import org.apache.kylin.invertedindex.IISegment;
import org.apache.kylin.invertedindex.model.IIDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.IBuildable;
import org.apache.kylin.metadata.model.LookupDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.metadata.realization.SQLDigest;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class IIInstance
extends RootPersistentEntity
implements IRealization,
IBuildable {
    @JsonIgnore
    private KylinConfig config;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="descriptor")
    private String descName;
    @JsonProperty(value="cost")
    private int cost = 50;
    @JsonProperty(value="status")
    private RealizationStatusEnum status;
    @JsonManagedReference
    @JsonProperty(value="segments")
    private List<IISegment> segments = new ArrayList<IISegment>();
    @JsonProperty(value="create_time_utc")
    private long createTimeUTC;
    private static final int COST_WEIGHT_LOOKUP_TABLE = 1;
    private static final int COST_WEIGHT_INNER_JOIN = 2;

    public static IIInstance create(String iiName, String projectName, IIDesc iiDesc) {
        IIInstance iii = new IIInstance();
        iii.setConfig(iiDesc.getConfig());
        iii.setName(iiName);
        iii.setDescName(iiDesc.getName());
        iii.setCreateTimeUTC(System.currentTimeMillis());
        iii.setStatus(RealizationStatusEnum.DISABLED);
        iii.updateRandomUuid();
        return iii;
    }

    public long getAllocatedEndDate() {
        if (null == this.segments || this.segments.size() == 0) {
            return 0L;
        }
        Collections.sort(this.segments);
        return this.segments.get(this.segments.size() - 1).getDateRangeEnd();
    }

    public long getAllocatedStartDate() {
        if (null == this.segments || this.segments.size() == 0) {
            return 0L;
        }
        Collections.sort(this.segments);
        return this.segments.get(0).getDateRangeStart();
    }

    public IIDesc getDescriptor() {
        return IIDescManager.getInstance(this.config).getIIDesc(this.descName);
    }

    @Override
    public DataModelDesc getDataModelDesc() {
        return this.getDescriptor().getModel();
    }

    @Override
    public boolean isReady() {
        return this.getStatus() == RealizationStatusEnum.READY;
    }

    public String getResourcePath() {
        return IIInstance.concatResourcePath(this.name);
    }

    public static String concatResourcePath(String cubeName) {
        return "/invertedindex/" + cubeName + ".json";
    }

    public String toString() {
        return this.getCanonicalName();
    }

    @JsonProperty(value="size_kb")
    public long getSizeKB() {
        long sizeKb = 0L;
        for (IISegment cubeSegment : this.getSegments(SegmentStatusEnum.READY)) {
            sizeKb += cubeSegment.getSizeKB();
        }
        return sizeKb;
    }

    @JsonProperty(value="input_records_count")
    public long getInputRecordCount() {
        long sizeRecordCount = 0L;
        for (IISegment cubeSegment : this.getSegments(SegmentStatusEnum.READY)) {
            sizeRecordCount += cubeSegment.getInputRecords();
        }
        return sizeRecordCount;
    }

    @JsonProperty(value="input_records_size")
    public long getInputRecordSize() {
        long sizeRecordSize = 0L;
        for (IISegment cubeSegment : this.getSegments(SegmentStatusEnum.READY)) {
            sizeRecordSize += cubeSegment.getInputRecordsSize();
        }
        return sizeRecordSize;
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public void setConfig(KylinConfig config) {
        this.config = config;
    }

    @Override
    public String getCanonicalName() {
        return (Object)((Object)this.getType()) + "[name=" + this.name + "]";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getDescName() {
        return this.descName;
    }

    public void setDescName(String descName) {
        this.descName = descName;
    }

    public int getCost() {
        return this.cost;
    }

    public RealizationStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(RealizationStatusEnum status) {
        this.status = status;
    }

    public IISegment getFirstSegment() {
        if (this.segments == null || this.segments.size() == 0) {
            return null;
        }
        return this.segments.get(0);
    }

    public List<IISegment> getSegments() {
        return this.segments;
    }

    public List<IISegment> getSegments(SegmentStatusEnum status) {
        ArrayList<IISegment> result = new ArrayList<IISegment>();
        for (IISegment segment : this.segments) {
            if (segment.getStatus() != status) continue;
            result.add(segment);
        }
        return result;
    }

    public IISegment getSegment(String name, SegmentStatusEnum status) {
        for (IISegment segment : this.segments) {
            if (null == segment.getName() || !segment.getName().equals(name) || segment.getStatus() != status) continue;
            return segment;
        }
        return null;
    }

    public void setSegments(List<IISegment> segments) {
        this.segments = segments;
    }

    public long getCreateTimeUTC() {
        return this.createTimeUTC;
    }

    public void setCreateTimeUTC(long createTimeUTC) {
        this.createTimeUTC = createTimeUTC;
    }

    @Override
    public CapabilityResult isCapable(SQLDigest digest) {
        CapabilityResult result = IICapabilityChecker.check(this, digest);
        result.cost = result.capable ? this.getCost(digest) : -1;
        return result;
    }

    private int getCost(SQLDigest digest) {
        int calculatedCost = this.cost;
        for (LookupDesc lookupDesc : this.getDescriptor().getModel().getLookups()) {
            ++calculatedCost;
            if (!"inner".equals(lookupDesc.getJoin().getType())) continue;
            calculatedCost += 2;
        }
        return calculatedCost;
    }

    @Override
    public RealizationType getType() {
        return RealizationType.INVERTED_INDEX;
    }

    @Override
    public List<TblColRef> getAllColumns() {
        return this.getDescriptor().listAllColumns();
    }

    @Override
    public String getFactTable() {
        return this.getDescriptor().getFactTableName();
    }

    @Override
    public List<MeasureDesc> getMeasures() {
        return this.getDescriptor().getMeasures();
    }

    @Override
    public long getDateRangeStart() {
        List<IISegment> readySegs = this.getSegments(SegmentStatusEnum.READY);
        long startTime = Long.MAX_VALUE;
        for (IISegment seg : readySegs) {
            if (seg.getDateRangeStart() >= startTime) continue;
            startTime = seg.getDateRangeStart();
        }
        return startTime;
    }

    @Override
    public long getDateRangeEnd() {
        List<IISegment> readySegs = this.getSegments(SegmentStatusEnum.READY);
        long endTime = 0L;
        for (IISegment seg : readySegs) {
            if (seg.getDateRangeEnd() <= endTime) continue;
            endTime = seg.getDateRangeEnd();
        }
        return endTime;
    }

    @Override
    public String getModelName() {
        return this.getDescriptor().getModelName();
    }

    @Override
    public List<TblColRef> getAllDimensions() {
        return this.getDescriptor().listAllDimensions();
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    @Override
    public int getStorageType() {
        return 0;
    }

    @Override
    public int getEngineType() {
        return this.getDescriptor().getEngineType();
    }

    @Override
    public int getSourceType() {
        return this.getDataModelDesc().getFactTableDesc().getSourceType();
    }
}

