/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.restclient.Broadcaster;
import org.apache.kylin.common.restclient.CaseInsensitiveStringCache;
import org.apache.kylin.invertedindex.model.IIDesc;
import org.apache.kylin.metadata.MetadataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IIDescManager {
    private static final Logger logger = LoggerFactory.getLogger(IIDescManager.class);
    private static final Serializer<IIDesc> II_DESC_SERIALIZER = new JsonSerializer<IIDesc>(IIDesc.class);
    private static final ConcurrentHashMap<KylinConfig, IIDescManager> CACHE = new ConcurrentHashMap();
    private KylinConfig config;
    private CaseInsensitiveStringCache<IIDesc> iiDescMap;

    public static IIDescManager getInstance(KylinConfig config) {
        IIDescManager r = CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<IIDescManager> clazz = IIDescManager.class;
        synchronized (IIDescManager.class) {
            r = CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new IIDescManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one singleton exist");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init IIDescManager from " + config, e);
            }
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    private IIDescManager(KylinConfig config) throws IOException {
        logger.info("Initializing IIDescManager with config " + config);
        this.config = config;
        this.iiDescMap = new CaseInsensitiveStringCache(config, Broadcaster.TYPE.INVERTED_INDEX_DESC);
        this.reloadAllIIDesc();
    }

    public List<IIDesc> listAllDesc() {
        return new ArrayList<IIDesc>(this.iiDescMap.values());
    }

    public IIDesc getIIDesc(String name) {
        return (IIDesc)this.iiDescMap.get(name);
    }

    public IIDesc reloadIIDescLocal(String name) throws IOException {
        String path = IIDesc.getIIDescResourcePath(name);
        IIDesc ndesc = this.loadIIDesc(path);
        this.iiDescMap.putLocal(ndesc.getName(), ndesc);
        return ndesc;
    }

    private IIDesc loadIIDesc(String path) throws IOException {
        ResourceStore store = this.getStore();
        logger.info("Loading IIDesc " + store.getReadableResourcePath(path));
        IIDesc ndesc = store.getResource(path, IIDesc.class, II_DESC_SERIALIZER);
        if (StringUtils.isBlank((CharSequence)ndesc.getName())) {
            throw new IllegalStateException("IIDesc name must not be blank");
        }
        ndesc.init(this.getMetadataManager());
        return ndesc;
    }

    public IIDesc createIIDesc(IIDesc iiDesc) throws IOException {
        if (iiDesc.getUuid() == null || iiDesc.getName() == null) {
            throw new IllegalArgumentException();
        }
        if (this.iiDescMap.containsKey(iiDesc.getName())) {
            throw new IllegalArgumentException("IIDesc '" + iiDesc.getName() + "' already exists");
        }
        iiDesc.init(this.getMetadataManager());
        iiDesc.setSignature(iiDesc.calculateSignature());
        String path = iiDesc.getResourcePath();
        this.getStore().putResource(path, iiDesc, II_DESC_SERIALIZER);
        this.iiDescMap.put(iiDesc.getName(), iiDesc);
        return iiDesc;
    }

    public void removeIIDesc(IIDesc iiDesc) throws IOException {
        String path = iiDesc.getResourcePath();
        this.getStore().deleteResource(path);
        this.iiDescMap.remove(iiDesc.getName());
    }

    public void removeIIDescLocal(String name) throws IOException {
        this.iiDescMap.removeLocal(name);
    }

    private void reloadAllIIDesc() throws IOException {
        ResourceStore store = this.getStore();
        logger.info("Reloading all II desc from folder " + store.getReadableResourcePath("/invertedindex_desc"));
        this.iiDescMap.clear();
        List<String> paths = store.collectResourceRecursively("/invertedindex_desc", ".json");
        for (String path : paths) {
            IIDesc desc;
            logger.info("loading II Desc from path" + path);
            try {
                desc = this.loadIIDesc(path);
            }
            catch (Exception e) {
                logger.error("Error loading II desc " + path, (Throwable)e);
                continue;
            }
            if (!path.equals(desc.getResourcePath())) {
                logger.error("Skip suspicious desc at " + path + ", " + desc + " should be at " + desc.getResourcePath());
                continue;
            }
            if (this.iiDescMap.containsKey(desc.getName())) {
                logger.error("Dup IIDesc name '" + desc.getName() + "' on path " + path);
                continue;
            }
            this.iiDescMap.putLocal(desc.getName(), desc);
        }
        logger.debug("Loaded " + this.iiDescMap.size() + " II desc(s)");
    }

    public IIDesc updateIIDesc(IIDesc desc) throws IOException {
        if (desc.getUuid() == null || desc.getName() == null) {
            throw new IllegalArgumentException();
        }
        String name = desc.getName();
        if (!this.iiDescMap.containsKey(name)) {
            throw new IllegalArgumentException("IIDesc '" + name + "' does not exist.");
        }
        desc.init(this.getMetadataManager());
        desc.setSignature(desc.calculateSignature());
        String path = desc.getResourcePath();
        this.getStore().putResource(path, desc, II_DESC_SERIALIZER);
        IIDesc ndesc = this.loadIIDesc(path);
        this.iiDescMap.put(ndesc.getName(), desc);
        return ndesc;
    }

    private MetadataManager getMetadataManager() {
        return MetadataManager.getInstance(this.config);
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }
}

