/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.invertedindex.model.IIDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.LookupDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IICapabilityChecker {
    private static final Logger logger = LoggerFactory.getLogger(IICapabilityChecker.class);

    public static CapabilityResult check(IIInstance ii, SQLDigest digest) {
        CapabilityResult result = new CapabilityResult();
        result.capable = false;
        if (!digest.factTable.equalsIgnoreCase(ii.getFactTable())) {
            logger.info("Exclude II " + ii.getName() + " because fact table unmatch");
            return result;
        }
        boolean matchJoin = IICapabilityChecker.isMatchedWithJoins(digest.joinDescs, ii);
        if (!matchJoin) {
            logger.info("Exclude II " + ii.getName() + " because unmatched joins");
            return result;
        }
        Collection<TblColRef> dimensionColumns = IICapabilityChecker.getDimensionColumns(digest);
        Collection<FunctionDesc> aggrFunctions = digest.aggregations;
        Set<TblColRef> unmatchedDimensions = IICapabilityChecker.unmatchedDimensions(dimensionColumns, ii);
        Set<FunctionDesc> unmatchedAggregations = IICapabilityChecker.unmatchedAggregations(aggrFunctions, ii);
        if (!unmatchedAggregations.isEmpty()) {
            IICapabilityChecker.tryDimensionAsMeasures(unmatchedAggregations, digest, ii, result);
        }
        if (!unmatchedDimensions.isEmpty()) {
            logger.info("Exclude ii " + ii.getName() + " because unmatched dimensions");
            return result;
        }
        if (!unmatchedAggregations.isEmpty()) {
            logger.info("Exclude ii " + ii.getName() + " because unmatched aggregations");
            return result;
        }
        result.capable = true;
        return result;
    }

    private static boolean isMatchedWithJoins(Collection<JoinDesc> joins, IIInstance iiInstance) {
        IIDesc iiDesc = iiInstance.getDescriptor();
        List<TableDesc> tables = iiDesc.listTables();
        ArrayList<JoinDesc> cubeJoins = new ArrayList<JoinDesc>(tables.size());
        block0: for (TableDesc tableDesc : tables) {
            JoinDesc join = null;
            for (LookupDesc lookup : iiDesc.getModel().getLookups()) {
                if (!lookup.getTable().equalsIgnoreCase(tableDesc.getIdentity())) continue;
                join = lookup.getJoin();
                cubeJoins.add(join);
                continue block0;
            }
        }
        for (JoinDesc j : joins) {
            String fTable;
            String pTable = j.getPrimaryKeyColumns()[0].getTable();
            String factTable = iiDesc.getModel().getFactTable();
            if (factTable.equals(pTable)) {
                j.swapPKFK();
            }
            if (!factTable.equals(fTable = j.getForeignKeyColumns()[0].getTable())) {
                logger.info("Fact Table" + factTable + " not matched in join: " + j + " on ii " + iiInstance.getName());
                return false;
            }
            if (cubeJoins.contains(j)) continue;
            logger.info("Query joins don't match on ii " + iiInstance.getName());
            return false;
        }
        return true;
    }

    private static Collection<TblColRef> getDimensionColumns(SQLDigest sqlDigest) {
        Collection<TblColRef> groupByColumns = sqlDigest.groupbyColumns;
        Collection<TblColRef> filterColumns = sqlDigest.filterColumns;
        HashSet<TblColRef> dimensionColumns = new HashSet<TblColRef>();
        dimensionColumns.addAll(groupByColumns);
        dimensionColumns.addAll(filterColumns);
        return dimensionColumns;
    }

    private static Set<TblColRef> unmatchedDimensions(Collection<TblColRef> dimensionColumns, IIInstance ii) {
        HashSet result = Sets.newHashSet(dimensionColumns);
        result.removeAll(ii.getDescriptor().listAllDimensions());
        return result;
    }

    private static Set<FunctionDesc> unmatchedAggregations(Collection<FunctionDesc> aggregations, IIInstance ii) {
        HashSet result = Sets.newHashSet(aggregations);
        result.removeAll(ii.getDescriptor().listAllFunctions());
        return result;
    }

    private static void tryDimensionAsMeasures(Collection<FunctionDesc> unmatchedAggregations, SQLDigest digest, IIInstance ii, CapabilityResult result) {
        IIDesc iiDesc = ii.getDescriptor();
        List<FunctionDesc> iiFuncs = iiDesc.listAllFunctions();
        Iterator<FunctionDesc> it = unmatchedAggregations.iterator();
        while (it.hasNext()) {
            FunctionDesc functionDesc = it.next();
            if (iiFuncs.contains(functionDesc)) {
                it.remove();
                continue;
            }
            if (functionDesc.isCount()) {
                it.remove();
                continue;
            }
            List<TblColRef> neededCols = functionDesc.getParameter().getColRefs();
            if (neededCols.size() <= 0 || !iiDesc.listAllDimensions().containsAll(neededCols)) continue;
            result.influences.add(new CapabilityResult.DimensionAsMeasure(functionDesc));
            it.remove();
        }
    }
}

