/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.IGTComparator;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class GTUtil {
    static final TableDesc MOCKUP_TABLE = TableDesc.mockup("GT_MOCKUP_TABLE");

    static TblColRef tblColRef(int col, String datatype) {
        ColumnDesc desc = ColumnDesc.mockup(MOCKUP_TABLE, col + 1, "" + col, datatype);
        return new TblColRef(desc);
    }

    public static byte[] serializeGTFilter(TupleFilter gtFilter, GTInfo info) {
        IFilterCodeSystem<ByteArray> filterCodeSystem = GTUtil.wrap(info.codeSystem.getComparator());
        return TupleFilterSerializer.serialize(gtFilter, filterCodeSystem);
    }

    public static TupleFilter deserializeGTFilter(byte[] bytes, GTInfo info) {
        IFilterCodeSystem<ByteArray> filterCodeSystem = GTUtil.wrap(info.codeSystem.getComparator());
        return TupleFilterSerializer.deserialize(bytes, filterCodeSystem);
    }

    public static TupleFilter convertFilterUnevaluatable(TupleFilter rootFilter, GTInfo info, Set<TblColRef> unevaluatableColumnCollector) {
        return GTUtil.convertFilter(rootFilter, info, null, false, unevaluatableColumnCollector);
    }

    public static TupleFilter convertFilterColumnsAndConstants(TupleFilter rootFilter, GTInfo info, List<TblColRef> colMapping, Set<TblColRef> unevaluatableColumnCollector) {
        return GTUtil.convertFilter(rootFilter, info, colMapping, true, unevaluatableColumnCollector);
    }

    private static TupleFilter convertFilter(TupleFilter rootFilter, final GTInfo info, final List<TblColRef> colMapping, final boolean encodeConstants, final Set<TblColRef> unevaluatableColumnCollector) {
        IFilterCodeSystem<ByteArray> filterCodeSystem = GTUtil.wrap(info.codeSystem.getComparator());
        byte[] bytes = TupleFilterSerializer.serialize(rootFilter, new TupleFilterSerializer.Decorator(){
            transient ByteBuffer buf;
            {
                this.buf = ByteBuffer.allocate(info.getMaxColumnLength());
            }

            @Override
            public TupleFilter onSerialize(TupleFilter filter) {
                if (filter == null) {
                    return null;
                }
                if (filter.getOperator() == TupleFilter.FilterOperatorEnum.NOT && !TupleFilter.isEvaluableRecursively(filter)) {
                    TupleFilter.collectColumns(filter, unevaluatableColumnCollector);
                    return ConstantTupleFilter.TRUE;
                }
                if (!filter.isEvaluable()) {
                    TupleFilter.collectColumns(filter, unevaluatableColumnCollector);
                    return ConstantTupleFilter.TRUE;
                }
                if (colMapping != null && filter instanceof ColumnTupleFilter) {
                    ColumnTupleFilter colFilter = (ColumnTupleFilter)filter;
                    int gtColIdx = colMapping.indexOf(colFilter.getColumn());
                    return new ColumnTupleFilter(info.colRef(gtColIdx));
                }
                if (encodeConstants && filter instanceof CompareTupleFilter) {
                    return this.encodeConstants((CompareTupleFilter)filter);
                }
                return filter;
            }

            private TupleFilter encodeConstants(CompareTupleFilter oldCompareFilter) {
                TupleFilter result;
                TblColRef externalCol = oldCompareFilter.getColumn();
                if (externalCol == null) {
                    return oldCompareFilter;
                }
                Collection constValues = oldCompareFilter.getValues();
                if (constValues == null || constValues.isEmpty()) {
                    return oldCompareFilter;
                }
                CompareTupleFilter newCompareFilter = new CompareTupleFilter(oldCompareFilter.getOperator());
                newCompareFilter.addChild(new ColumnTupleFilter(externalCol));
                Object firstValue = constValues.iterator().next();
                int col = colMapping == null ? externalCol.getColumnDesc().getZeroBasedIndex() : colMapping.indexOf(externalCol);
                switch (newCompareFilter.getOperator()) {
                    case EQ: 
                    case IN: {
                        HashSet newValues = Sets.newHashSet();
                        for (Object value : constValues) {
                            ByteArray code = this.translate(col, value, 0);
                            if (code == null) continue;
                            newValues.add(code);
                        }
                        if (newValues.isEmpty()) {
                            result = ConstantTupleFilter.FALSE;
                            break;
                        }
                        newCompareFilter.addChild(new ConstantTupleFilter(newValues));
                        result = newCompareFilter;
                        break;
                    }
                    case NEQ: {
                        ByteArray code = this.translate(col, firstValue, 0);
                        if (code == null) {
                            result = ConstantTupleFilter.TRUE;
                            break;
                        }
                        newCompareFilter.addChild(new ConstantTupleFilter(code));
                        result = newCompareFilter;
                        break;
                    }
                    case LT: {
                        ByteArray code = this.translate(col, firstValue, 1);
                        if (code == null) {
                            result = ConstantTupleFilter.TRUE;
                            break;
                        }
                        newCompareFilter.addChild(new ConstantTupleFilter(code));
                        result = newCompareFilter;
                        break;
                    }
                    case LTE: {
                        ByteArray code = this.translate(col, firstValue, -1);
                        if (code == null) {
                            result = ConstantTupleFilter.FALSE;
                            break;
                        }
                        newCompareFilter.addChild(new ConstantTupleFilter(code));
                        result = newCompareFilter;
                        break;
                    }
                    case GT: {
                        ByteArray code = this.translate(col, firstValue, -1);
                        if (code == null) {
                            result = ConstantTupleFilter.TRUE;
                            break;
                        }
                        newCompareFilter.addChild(new ConstantTupleFilter(code));
                        result = newCompareFilter;
                        break;
                    }
                    case GTE: {
                        ByteArray code = this.translate(col, firstValue, 1);
                        if (code == null) {
                            result = ConstantTupleFilter.FALSE;
                            break;
                        }
                        newCompareFilter.addChild(new ConstantTupleFilter(code));
                        result = newCompareFilter;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Cannot handle operator " + (Object)((Object)newCompareFilter.getOperator()));
                    }
                }
                return result;
            }

            private ByteArray translate(int col, Object value, int roundingFlag) {
                try {
                    this.buf.clear();
                    info.codeSystem.encodeColumnValue(col, value, roundingFlag, this.buf);
                    return ByteArray.copyOf(this.buf.array(), 0, this.buf.position());
                }
                catch (IllegalArgumentException ex) {
                    return null;
                }
            }
        }, filterCodeSystem);
        return TupleFilterSerializer.deserialize(bytes, filterCodeSystem);
    }

    public static IFilterCodeSystem<ByteArray> wrap(final IGTComparator comp) {
        return new IFilterCodeSystem<ByteArray>(){

            @Override
            public int compare(ByteArray o1, ByteArray o2) {
                return comp.compare(o1, o2);
            }

            @Override
            public boolean isNull(ByteArray code) {
                return comp.isNull(code);
            }

            @Override
            public void serialize(ByteArray code, ByteBuffer buffer) {
                if (code == null) {
                    BytesUtil.writeByteArray(null, 0, 0, buffer);
                } else {
                    BytesUtil.writeByteArray(code.array(), code.offset(), code.length(), buffer);
                }
            }

            @Override
            public ByteArray deserialize(ByteBuffer buffer) {
                return new ByteArray(BytesUtil.readByteArray(buffer));
            }
        };
    }
}

