/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.FuzzyValueCombination;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.gridtable.CubeGridTable;
import org.apache.kylin.cube.gridtable.CuboidToGridTableMapping;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRange;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.GTUtil;
import org.apache.kylin.gridtable.IGTComparator;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTScanRangePlanner {
    private static final Logger logger = LoggerFactory.getLogger(GTScanRangePlanner.class);
    protected int maxScanRanges = KylinConfig.getInstanceFromEnv().getQueryStorageVisitScanRangeMax();
    protected int maxFuzzyKeys = KylinConfig.getInstanceFromEnv().getQueryScanFuzzyKeyMax();
    protected CubeSegment cubeSegment;
    protected CubeDesc cubeDesc;
    protected Cuboid cuboid;
    protected TupleFilter filter;
    protected Set<TblColRef> dimensions;
    protected Set<TblColRef> groupbyDims;
    protected Set<TblColRef> filterDims;
    protected Collection<FunctionDesc> metrics;
    protected TupleFilter gtFilter;
    protected GTInfo gtInfo;
    protected Pair<ByteArray, ByteArray> gtStartAndEnd;
    protected TblColRef gtPartitionCol;
    protected ImmutableBitSet gtDimensions;
    protected ImmutableBitSet gtAggrGroups;
    protected ImmutableBitSet gtAggrMetrics;
    protected String[] gtAggrFuncs;
    protected final RecordComparator rangeStartComparator;
    protected final RecordComparator rangeEndComparator;
    protected final RecordComparator rangeStartEndComparator;

    public GTScanRangePlanner(CubeSegment cubeSegment, Cuboid cuboid, TupleFilter filter, Set<TblColRef> dimensions, Set<TblColRef> groupbyDims, Collection<FunctionDesc> metrics) {
        int index;
        this.cubeSegment = cubeSegment;
        this.cubeDesc = cubeSegment.getCubeDesc();
        this.cuboid = cuboid;
        this.dimensions = dimensions;
        this.groupbyDims = groupbyDims;
        this.filter = filter;
        this.metrics = metrics;
        this.filterDims = Sets.newHashSet();
        TupleFilter.collectColumns(filter, this.filterDims);
        this.gtInfo = CubeGridTable.newGTInfo(cubeSegment, cuboid.getId());
        CuboidToGridTableMapping mapping = cuboid.getCuboidToGridTableMapping();
        IGTComparator comp = this.gtInfo.codeSystem.getComparator();
        this.rangeStartComparator = GTScanRangePlanner.getRangeStartComparator(comp);
        this.rangeEndComparator = GTScanRangePlanner.getRangeEndComparator(comp);
        this.rangeStartEndComparator = GTScanRangePlanner.getRangeStartEndComparator(comp);
        this.gtFilter = GTUtil.convertFilterColumnsAndConstants(filter, this.gtInfo, mapping.getCuboidDimensionsInGTOrder(), this.groupbyDims);
        this.gtDimensions = this.makeGridTableColumns(mapping, dimensions);
        this.gtAggrGroups = this.makeGridTableColumns(mapping, this.replaceDerivedColumns(groupbyDims, cubeSegment.getCubeDesc()));
        this.gtAggrMetrics = this.makeGridTableColumns(mapping, metrics);
        this.gtAggrFuncs = this.makeAggrFuncs(mapping, metrics);
        if (cubeSegment.getCubeDesc().getModel().getPartitionDesc().isPartitioned() && (index = mapping.getIndexOf(cubeSegment.getCubeDesc().getModel().getPartitionDesc().getPartitionDateColumnRef())) >= 0) {
            this.gtStartAndEnd = this.getSegmentStartAndEnd(index);
            this.gtPartitionCol = this.gtInfo.colRef(index);
        }
    }

    public GTScanRangePlanner(GTInfo info, Pair<ByteArray, ByteArray> gtStartAndEnd, TblColRef gtPartitionCol, TupleFilter gtFilter) {
        this.gtInfo = info;
        IGTComparator comp = this.gtInfo.codeSystem.getComparator();
        this.rangeStartComparator = GTScanRangePlanner.getRangeStartComparator(comp);
        this.rangeEndComparator = GTScanRangePlanner.getRangeEndComparator(comp);
        this.rangeStartEndComparator = GTScanRangePlanner.getRangeStartEndComparator(comp);
        this.gtFilter = gtFilter;
        this.gtStartAndEnd = gtStartAndEnd;
        this.gtPartitionCol = gtPartitionCol;
    }

    public GTScanRequest planScanRequest(boolean allowPreAggregate) {
        List<GTScanRange> scanRanges = this.planScanRanges();
        GTScanRequest scanRequest = scanRanges != null && scanRanges.size() != 0 ? new GTScanRequest(this.gtInfo, scanRanges, this.gtDimensions, this.gtAggrGroups, this.gtAggrMetrics, this.gtAggrFuncs, this.gtFilter, allowPreAggregate, this.cubeSegment.getCubeInstance().getConfig().getQueryCoprocessorMemGB()) : null;
        return scanRequest;
    }

    public List<GTScanRange> planScanRanges() {
        TupleFilter flatFilter = this.flattenToOrAndFilter(this.gtFilter);
        List<Collection<ColumnRange>> orAndDimRanges = this.translateToOrAndDimRanges(flatFilter);
        ArrayList scanRanges = Lists.newArrayListWithCapacity((int)orAndDimRanges.size());
        for (Collection<ColumnRange> andDimRanges : orAndDimRanges) {
            GTScanRange scanRange = this.newScanRange(andDimRanges);
            if (scanRange == null) continue;
            scanRanges.add(scanRange);
        }
        List<GTScanRange> mergedRanges = this.mergeOverlapRanges(scanRanges);
        mergedRanges = this.mergeTooManyRanges(mergedRanges, this.maxScanRanges);
        return mergedRanges;
    }

    private Pair<ByteArray, ByteArray> getSegmentStartAndEnd(int index) {
        ByteArray start = this.cubeSegment.getDateRangeStart() != Long.MIN_VALUE ? this.encodeTime(this.cubeSegment.getDateRangeStart(), index, 1) : new ByteArray();
        ByteArray end = this.cubeSegment.getDateRangeEnd() != Long.MAX_VALUE ? this.encodeTime(this.cubeSegment.getDateRangeEnd(), index, -1) : new ByteArray();
        return Pair.newPair(start, end);
    }

    private ByteArray encodeTime(long ts, int index, int roundingFlag) {
        String value;
        DataType partitionColType = this.gtInfo.getColumnType(index);
        if (partitionColType.isDate()) {
            value = DateFormat.formatToDateStr(ts);
        } else if (partitionColType.isDatetime() || partitionColType.isTimestamp()) {
            value = DateFormat.formatToTimeWithoutMilliStr(ts);
        } else if (partitionColType.isStringFamily()) {
            String partitionDateFormat = this.cubeSegment.getCubeDesc().getModel().getPartitionDesc().getPartitionDateFormat();
            if (StringUtils.isEmpty((CharSequence)partitionDateFormat)) {
                partitionDateFormat = "yyyy-MM-dd";
            }
            value = DateFormat.formatToDateStr(ts, partitionDateFormat);
        } else {
            throw new RuntimeException("Type " + partitionColType + " is not valid partition column type");
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.gtInfo.getMaxColumnLength());
        this.gtInfo.getCodeSystem().encodeColumnValue(index, value, roundingFlag, buffer);
        return ByteArray.copyOf(buffer.array(), 0, buffer.position());
    }

    private Set<TblColRef> replaceDerivedColumns(Set<TblColRef> input, CubeDesc cubeDesc) {
        HashSet ret = Sets.newHashSet();
        for (TblColRef col : input) {
            if (cubeDesc.hasHostColumn(col)) {
                for (TblColRef host : cubeDesc.getHostInfo((TblColRef)col).columns) {
                    ret.add(host);
                }
                continue;
            }
            ret.add(col);
        }
        return ret;
    }

    private ImmutableBitSet makeGridTableColumns(CuboidToGridTableMapping mapping, Set<TblColRef> dimensions) {
        BitSet result = new BitSet();
        for (TblColRef dim : dimensions) {
            int idx = mapping.getIndexOf(dim);
            if (idx < 0) continue;
            result.set(idx);
        }
        return new ImmutableBitSet(result);
    }

    private ImmutableBitSet makeGridTableColumns(CuboidToGridTableMapping mapping, Collection<FunctionDesc> metrics) {
        BitSet result = new BitSet();
        for (FunctionDesc metric : metrics) {
            int idx = mapping.getIndexOf(metric);
            if (idx < 0) {
                throw new IllegalStateException(metric + " not found in " + mapping);
            }
            result.set(idx);
        }
        return new ImmutableBitSet(result);
    }

    private String[] makeAggrFuncs(final CuboidToGridTableMapping mapping, Collection<FunctionDesc> metrics) {
        ArrayList metricList = Lists.newArrayList(metrics);
        Collections.sort(metricList, new Comparator<FunctionDesc>(){

            @Override
            public int compare(FunctionDesc o1, FunctionDesc o2) {
                int a = mapping.getIndexOf(o1);
                int b = mapping.getIndexOf(o2);
                return a - b;
            }
        });
        String[] result = new String[metricList.size()];
        int i = 0;
        for (FunctionDesc metric : metricList) {
            result[i++] = metric.getExpression();
        }
        return result;
    }

    private String makeReadable(ByteArray byteArray) {
        if (byteArray == null) {
            return null;
        }
        return byteArray.toReadableText();
    }

    protected GTScanRange newScanRange(Collection<ColumnRange> andDimRanges) {
        GTRecord pkStart = new GTRecord(this.gtInfo);
        GTRecord pkEnd = new GTRecord(this.gtInfo);
        HashMap fuzzyValues = Maps.newHashMap();
        for (ColumnRange range : andDimRanges) {
            if (this.gtPartitionCol != null && range.column.equals(this.gtPartitionCol) && (this.rangeStartEndComparator.comparator.compare(this.gtStartAndEnd.getFirst(), range.end) > 0 || this.rangeStartEndComparator.comparator.compare(range.begin, this.gtStartAndEnd.getSecond()) >= 0 && (this.rangeStartEndComparator.comparator.compare(range.begin, this.gtStartAndEnd.getSecond()) != 0 || range.op != TupleFilter.FilterOperatorEnum.EQ && range.op != TupleFilter.FilterOperatorEnum.LTE && range.op != TupleFilter.FilterOperatorEnum.GTE && range.op != TupleFilter.FilterOperatorEnum.IN))) {
                logger.debug("Pre-check partition col filter failed, partitionColRef {}, segment start {}, segment end {}, range begin {}, range end {}", new Object[]{this.gtPartitionCol, this.makeReadable(this.gtStartAndEnd.getFirst()), this.makeReadable(this.gtStartAndEnd.getSecond()), this.makeReadable(range.begin), this.makeReadable(range.end)});
                return null;
            }
            int col = range.column.getColumnDesc().getZeroBasedIndex();
            if (!this.gtInfo.primaryKey.get(col)) continue;
            pkStart.set(col, range.begin);
            pkEnd.set(col, range.end);
            if (range.valueSet == null || range.valueSet.isEmpty()) continue;
            fuzzyValues.put(col, range.valueSet);
        }
        List<GTRecord> fuzzyKeys = this.buildFuzzyKeys(fuzzyValues);
        return new GTScanRange(pkStart, pkEnd, fuzzyKeys);
    }

    private List<GTRecord> buildFuzzyKeys(Map<Integer, Set<ByteArray>> fuzzyValueSet) {
        ArrayList result = Lists.newArrayList();
        if (fuzzyValueSet.isEmpty()) {
            return result;
        }
        if (BackdoorToggles.getDisableFuzzyKey()) {
            logger.info("The execution of this query will not use fuzzy key");
            return result;
        }
        List<Map<Integer, ByteArray>> fuzzyValueCombinations = FuzzyValueCombination.calculate(fuzzyValueSet, this.maxFuzzyKeys);
        for (Map<Integer, ByteArray> fuzzyValue : fuzzyValueCombinations) {
            BitSet bitSet = new BitSet(this.gtInfo.getColumnCount());
            for (Map.Entry<Integer, ByteArray> entry : fuzzyValue.entrySet()) {
                bitSet.set(entry.getKey());
            }
            GTRecord fuzzy = new GTRecord(this.gtInfo, new ImmutableBitSet(bitSet));
            for (Map.Entry<Integer, ByteArray> entry : fuzzyValue.entrySet()) {
                fuzzy.set(entry.getKey(), entry.getValue());
            }
            result.add(fuzzy);
        }
        return result;
    }

    protected TupleFilter flattenToOrAndFilter(TupleFilter filter) {
        if (filter == null) {
            return null;
        }
        TupleFilter flatFilter = filter.flatFilter();
        if (flatFilter.getOperator() == TupleFilter.FilterOperatorEnum.AND) {
            LogicalTupleFilter f = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
            f.addChild(flatFilter);
            flatFilter = f;
        }
        if (flatFilter.getOperator() != TupleFilter.FilterOperatorEnum.OR) {
            throw new IllegalStateException();
        }
        return flatFilter;
    }

    protected List<Collection<ColumnRange>> translateToOrAndDimRanges(TupleFilter flatFilter) {
        ArrayList result = Lists.newArrayList();
        if (flatFilter == null) {
            result.add(Collections.emptyList());
            return result;
        }
        for (TupleFilter tupleFilter : flatFilter.getChildren()) {
            if (tupleFilter.getOperator() != TupleFilter.FilterOperatorEnum.AND) {
                throw new IllegalStateException("Filter should be AND instead of " + tupleFilter);
            }
            Collection<ColumnRange> andRanges = this.translateToAndDimRanges(tupleFilter.getChildren());
            if (andRanges == null) continue;
            result.add(andRanges);
        }
        return this.preEvaluateConstantConditions(result);
    }

    private Collection<ColumnRange> translateToAndDimRanges(List<? extends TupleFilter> andFilters) {
        HashMap<TblColRef, ColumnRange> rangeMap = new HashMap<TblColRef, ColumnRange>();
        for (TupleFilter tupleFilter : andFilters) {
            if (!(tupleFilter instanceof CompareTupleFilter)) {
                if (!(tupleFilter instanceof ConstantTupleFilter) || tupleFilter.evaluate(null, null)) continue;
                return null;
            }
            CompareTupleFilter comp = (CompareTupleFilter)tupleFilter;
            if (comp.getColumn() == null) continue;
            ColumnRange newRange = new ColumnRange(comp.getColumn(), (Set<ByteArray>)comp.getValues(), comp.getOperator());
            ColumnRange existing = (ColumnRange)rangeMap.get(newRange.column);
            if (existing == null) {
                rangeMap.put(newRange.column, newRange);
                continue;
            }
            existing.andMerge(newRange);
        }
        return rangeMap.values();
    }

    private List<Collection<ColumnRange>> preEvaluateConstantConditions(List<Collection<ColumnRange>> orAndRanges) {
        boolean globalAlwaysTrue = false;
        Iterator<Collection<ColumnRange>> iterator = orAndRanges.iterator();
        while (iterator.hasNext()) {
            Collection<ColumnRange> andRanges = iterator.next();
            Iterator<ColumnRange> iterator2 = andRanges.iterator();
            boolean hasAlwaysFalse = false;
            while (iterator2.hasNext()) {
                ColumnRange range = iterator2.next();
                if (range.satisfyAll()) {
                    iterator2.remove();
                    continue;
                }
                if (!range.satisfyNone()) continue;
                hasAlwaysFalse = true;
            }
            if (hasAlwaysFalse) {
                iterator.remove();
                continue;
            }
            if (!andRanges.isEmpty()) continue;
            globalAlwaysTrue = true;
            break;
        }
        if (globalAlwaysTrue) {
            orAndRanges.clear();
            orAndRanges.add(Collections.emptyList());
        }
        return orAndRanges;
    }

    protected List<GTScanRange> mergeOverlapRanges(List<GTScanRange> ranges) {
        if (ranges.size() <= 1) {
            return ranges;
        }
        Collections.sort(ranges, new Comparator<GTScanRange>(){

            @Override
            public int compare(GTScanRange a, GTScanRange b) {
                return GTScanRangePlanner.this.rangeStartComparator.compare(a.pkStart, b.pkStart);
            }
        });
        ArrayList<GTScanRange> mergedRanges = new ArrayList<GTScanRange>();
        int mergeBeginIndex = 0;
        GTRecord mergeEnd = ranges.get((int)0).pkEnd;
        for (int index = 1; index < ranges.size(); ++index) {
            GTScanRange range = ranges.get(index);
            if (this.rangeStartEndComparator.compare(range.pkStart, mergeEnd) <= 0) {
                mergeEnd = this.rangeEndComparator.max(mergeEnd, range.pkEnd);
                continue;
            }
            GTScanRange mergedRange = this.mergeKeyRange(ranges.subList(mergeBeginIndex, index));
            mergedRanges.add(mergedRange);
            mergeBeginIndex = index;
            mergeEnd = range.pkEnd;
        }
        GTScanRange mergedRange = this.mergeKeyRange(ranges.subList(mergeBeginIndex, ranges.size()));
        mergedRanges.add(mergedRange);
        return mergedRanges;
    }

    private GTScanRange mergeKeyRange(List<GTScanRange> ranges) {
        GTScanRange first = ranges.get(0);
        if (ranges.size() == 1) {
            return first;
        }
        GTRecord start = first.pkStart;
        GTRecord end = first.pkEnd;
        ArrayList<GTRecord> newFuzzyKeys = new ArrayList<GTRecord>();
        boolean hasNonFuzzyRange = false;
        for (GTScanRange range : ranges) {
            hasNonFuzzyRange = hasNonFuzzyRange || range.fuzzyKeys.isEmpty();
            newFuzzyKeys.addAll(range.fuzzyKeys);
            end = this.rangeEndComparator.max(end, range.pkEnd);
        }
        if (hasNonFuzzyRange || newFuzzyKeys.size() > this.maxFuzzyKeys) {
            newFuzzyKeys.clear();
        }
        return new GTScanRange(start, end, newFuzzyKeys);
    }

    protected List<GTScanRange> mergeTooManyRanges(List<GTScanRange> ranges, int maxRanges) {
        if (ranges.size() <= maxRanges) {
            return ranges;
        }
        ArrayList<GTScanRange> result = new ArrayList<GTScanRange>(1);
        GTScanRange mergedRange = this.mergeKeyRange(ranges);
        result.add(mergedRange);
        return result;
    }

    public int getMaxScanRanges() {
        return this.maxScanRanges;
    }

    public void setMaxScanRanges(int maxScanRanges) {
        this.maxScanRanges = maxScanRanges;
    }

    public static RecordComparator getRangeStartComparator(final IGTComparator comp) {
        return new RecordComparator(new ComparatorEx<ByteArray>(){

            @Override
            public int compare(ByteArray a, ByteArray b) {
                if (a.array() == null) {
                    if (b.array() == null) {
                        return 0;
                    }
                    return -1;
                }
                if (b.array() == null) {
                    return 1;
                }
                return comp.compare(a, b);
            }
        });
    }

    public static RecordComparator getRangeEndComparator(final IGTComparator comp) {
        return new RecordComparator(new ComparatorEx<ByteArray>(){

            @Override
            public int compare(ByteArray a, ByteArray b) {
                if (a.array() == null) {
                    if (b.array() == null) {
                        return 0;
                    }
                    return 1;
                }
                if (b.array() == null) {
                    return -1;
                }
                return comp.compare(a, b);
            }
        });
    }

    public static RecordComparator getRangeStartEndComparator(final IGTComparator comp) {
        return new AsymmetricRecordComparator(new ComparatorEx<ByteArray>(){

            @Override
            public int compare(ByteArray a, ByteArray b) {
                if (a.array() == null || b.array() == null) {
                    return -1;
                }
                return comp.compare(a, b);
            }
        });
    }

    private static class AsymmetricRecordComparator
    extends RecordComparator {
        AsymmetricRecordComparator(ComparatorEx<ByteArray> byteComparator) {
            super(byteComparator);
        }

        @Override
        public GTRecord min(Collection<GTRecord> v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public GTRecord max(Collection<GTRecord> v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public GTRecord min(GTRecord a, GTRecord b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public GTRecord max(GTRecord a, GTRecord b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean between(GTRecord v, GTRecord start, GTRecord end) {
            throw new UnsupportedOperationException();
        }
    }

    private static class RecordComparator
    extends ComparatorEx<GTRecord> {
        final ComparatorEx<ByteArray> comparator;

        RecordComparator(ComparatorEx<ByteArray> byteComparator) {
            this.comparator = byteComparator;
        }

        @Override
        public int compare(GTRecord a, GTRecord b) {
            assert (a.info == b.info);
            assert (a.maskForEqualHashComp() == b.maskForEqualHashComp());
            ImmutableBitSet mask = a.maskForEqualHashComp();
            for (int i = 0; i < mask.trueBitCount(); ++i) {
                int c = mask.trueBitAt(i);
                int comp = this.comparator.compare(a.cols[c], b.cols[c]);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    }

    public static abstract class ComparatorEx<T>
    implements Comparator<T> {
        public T min(Collection<T> v) {
            if (v.size() <= 0) {
                return null;
            }
            Iterator<T> iterator = v.iterator();
            T min = iterator.next();
            while (iterator.hasNext()) {
                min = this.min(min, iterator.next());
            }
            return min;
        }

        public T max(Collection<T> v) {
            if (v.size() <= 0) {
                return null;
            }
            Iterator<T> iterator = v.iterator();
            T max = iterator.next();
            while (iterator.hasNext()) {
                max = this.max(max, iterator.next());
            }
            return max;
        }

        public T min(T a, T b) {
            return this.compare(a, b) <= 0 ? a : b;
        }

        public T max(T a, T b) {
            return this.compare(a, b) >= 0 ? a : b;
        }

        public boolean between(T v, T start, T end) {
            return this.compare(start, v) <= 0 && this.compare(v, end) <= 0;
        }
    }

    protected class ColumnRange {
        private TblColRef column;
        private ByteArray begin = ByteArray.EMPTY;
        private ByteArray end = ByteArray.EMPTY;
        private Set<ByteArray> valueSet;
        private TupleFilter.FilterOperatorEnum op;

        public ColumnRange(TblColRef column, Set<ByteArray> values, TupleFilter.FilterOperatorEnum op) {
            this.column = column;
            this.op = op;
            switch (op) {
                case EQ: 
                case IN: {
                    this.valueSet = new HashSet<ByteArray>(values);
                    this.refreshBeginEndFromEquals();
                    break;
                }
                case LT: 
                case LTE: {
                    this.end = GTScanRangePlanner.this.rangeEndComparator.comparator.max(values);
                    break;
                }
                case GT: 
                case GTE: {
                    this.begin = GTScanRangePlanner.this.rangeStartComparator.comparator.min(values);
                    break;
                }
                case NEQ: 
                case NOTIN: 
                case ISNULL: 
                case ISNOTNULL: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(op.name());
                }
            }
        }

        void copy(TblColRef column, ByteArray beginValue, ByteArray endValue, Set<ByteArray> equalValues) {
            this.column = column;
            this.begin = beginValue;
            this.end = endValue;
            this.valueSet = equalValues;
        }

        private void refreshBeginEndFromEquals() {
            if (this.valueSet.isEmpty()) {
                this.begin = ByteArray.EMPTY;
                this.end = ByteArray.EMPTY;
            } else {
                this.begin = GTScanRangePlanner.this.rangeStartComparator.comparator.min(this.valueSet);
                this.end = GTScanRangePlanner.this.rangeEndComparator.comparator.max(this.valueSet);
            }
        }

        public boolean satisfyAll() {
            return this.begin.array() == null && this.end.array() == null;
        }

        public boolean satisfyNone() {
            if (this.valueSet != null) {
                return this.valueSet.isEmpty();
            }
            if (this.begin.array() != null && this.end.array() != null) {
                return GTScanRangePlanner.this.gtInfo.codeSystem.getComparator().compare(this.begin, this.end) > 0;
            }
            return false;
        }

        public void andMerge(ColumnRange another) {
            assert (this.column.equals(another.column));
            if (another.satisfyAll()) {
                return;
            }
            if (this.satisfyAll()) {
                this.copy(another.column, another.begin, another.end, another.valueSet);
                return;
            }
            if (this.valueSet != null && another.valueSet != null) {
                this.valueSet.retainAll(another.valueSet);
                this.refreshBeginEndFromEquals();
                return;
            }
            if (this.valueSet != null) {
                this.valueSet = this.filter(this.valueSet, another.begin, another.end);
                this.refreshBeginEndFromEquals();
                return;
            }
            if (another.valueSet != null) {
                this.valueSet = this.filter(another.valueSet, this.begin, this.end);
                this.refreshBeginEndFromEquals();
                return;
            }
            this.begin = GTScanRangePlanner.this.rangeStartComparator.comparator.max(this.begin, another.begin);
            this.end = GTScanRangePlanner.this.rangeEndComparator.comparator.min(this.end, another.end);
        }

        private Set<ByteArray> filter(Set<ByteArray> equalValues, ByteArray beginValue, ByteArray endValue) {
            HashSet result = Sets.newHashSetWithExpectedSize((int)equalValues.size());
            for (ByteArray v : equalValues) {
                if (GTScanRangePlanner.this.rangeStartEndComparator.comparator.compare(beginValue, v) > 0 || GTScanRangePlanner.this.rangeStartEndComparator.comparator.compare(v, endValue) > 0) continue;
                result.add(v);
            }
            return equalValues;
        }

        public String toString() {
            if (this.valueSet == null) {
                return this.column.getName() + " between " + this.begin + " and " + this.end;
            }
            return this.column.getName() + " in " + this.valueSet;
        }
    }
}

