/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.IGTComparator;

public class GTRecord
implements Comparable<GTRecord> {
    final transient GTInfo info;
    final ByteArray[] cols;
    final ImmutableBitSet maskForEqualHashComp;

    public GTRecord(GTInfo info, ImmutableBitSet maskForEqualHashComp, ByteArray[] cols) {
        this.info = info;
        this.cols = cols;
        this.maskForEqualHashComp = maskForEqualHashComp;
    }

    public GTRecord(GTInfo info, ImmutableBitSet maskForEqualHashComp) {
        this.cols = new ByteArray[info.getColumnCount()];
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i] = new ByteArray();
        }
        this.info = info;
        this.maskForEqualHashComp = maskForEqualHashComp;
    }

    public GTRecord(GTInfo info) {
        this(info, info.colAll);
    }

    public GTRecord(GTInfo info, ByteArray[] cols) {
        this(info, info.colAll, cols);
    }

    public GTRecord(GTRecord other) {
        this.info = other.info;
        this.maskForEqualHashComp = other.maskForEqualHashComp;
        this.cols = new ByteArray[this.info.getColumnCount()];
        for (int i = 0; i < other.cols.length; ++i) {
            this.cols[i] = other.cols[i].copy();
        }
    }

    public GTInfo getInfo() {
        return this.info;
    }

    public ByteArray get(int i) {
        return this.cols[i];
    }

    public ByteArray[] getInternal() {
        return this.cols;
    }

    public void set(int i, ByteArray data) {
        this.cols[i].set(data.array(), data.offset(), data.length());
    }

    public GTRecord setValues(Object ... values) {
        this.setValues(this.info.colAll, new ByteArray(this.info.getMaxRecordLength()), values);
        return this;
    }

    public GTRecord setValues(ImmutableBitSet selectedCols, ByteArray space, Object ... values) {
        assert (selectedCols.cardinality() == values.length);
        ByteBuffer buf = space.asBuffer();
        int pos = buf.position();
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            this.info.codeSystem.encodeColumnValue(c, values[i], buf);
            int newPos = buf.position();
            this.cols[c].set(buf.array(), buf.arrayOffset() + pos, newPos - pos);
            pos = newPos;
        }
        return this;
    }

    public Object[] getValues() {
        return this.getValues(this.info.colAll, new Object[this.info.getColumnCount()]);
    }

    public Object[] getValues(ImmutableBitSet selectedCols, Object[] result) {
        assert (selectedCols.cardinality() == result.length);
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            result[i] = this.cols[c] == null || this.cols[c].array() == null ? null : this.info.codeSystem.decodeColumnValue(c, this.cols[c].asBuffer());
        }
        return result;
    }

    public Object[] getValues(int[] selectedColumns, Object[] result) {
        assert (selectedColumns.length <= result.length);
        for (int i = 0; i < selectedColumns.length; ++i) {
            int c = selectedColumns[i];
            result[i] = this.cols[c].array() == null ? null : this.info.codeSystem.decodeColumnValue(c, this.cols[c].asBuffer());
        }
        return result;
    }

    public GTRecord copy() {
        return this.copy(this.info.colAll);
    }

    public GTRecord copy(ImmutableBitSet selectedCols) {
        int len = 0;
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            len += this.cols[c].length();
        }
        byte[] space = new byte[len];
        GTRecord copy = new GTRecord(this.info, this.maskForEqualHashComp);
        int pos = 0;
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            System.arraycopy(this.cols[c].array(), this.cols[c].offset(), space, pos, this.cols[c].length());
            copy.cols[c].set(space, pos, this.cols[c].length());
            pos += this.cols[c].length();
        }
        return copy;
    }

    public ImmutableBitSet maskForEqualHashComp() {
        return this.maskForEqualHashComp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTRecord o = (GTRecord)obj;
        if (this.info != o.info) {
            return false;
        }
        if (this.maskForEqualHashComp != o.maskForEqualHashComp) {
            return false;
        }
        for (int i = 0; i < this.maskForEqualHashComp.trueBitCount(); ++i) {
            int c = this.maskForEqualHashComp.trueBitAt(i);
            if (this.cols[c].equals(o.cols[c])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.maskForEqualHashComp.trueBitCount(); ++i) {
            int c = this.maskForEqualHashComp.trueBitAt(i);
            hash = 31 * hash + this.cols[c].hashCode();
        }
        return hash;
    }

    @Override
    public int compareTo(GTRecord o) {
        assert (this.info == o.info);
        assert (this.maskForEqualHashComp == o.maskForEqualHashComp);
        IGTComparator comparator = this.info.codeSystem.getComparator();
        int comp = 0;
        for (int i = 0; i < this.maskForEqualHashComp.trueBitCount(); ++i) {
            int c = this.maskForEqualHashComp.trueBitAt(i);
            comp = comparator.compare(this.cols[c], o.cols[c]);
            if (comp == 0) continue;
            return comp;
        }
        return comp;
    }

    public String toString() {
        return this.toString(this.maskForEqualHashComp);
    }

    public String toString(ImmutableBitSet selectedColumns) {
        Object[] values = new Object[selectedColumns.cardinality()];
        this.getValues(selectedColumns, values);
        return Arrays.toString(values);
    }

    public ByteArray exportColumns(ImmutableBitSet selectedCols) {
        int len = 0;
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            len += this.cols[c].length();
        }
        ByteArray buf = ByteArray.allocate(len);
        this.exportColumns(selectedCols, buf);
        return buf;
    }

    public void exportColumns(ImmutableBitSet selectedCols, ByteArray buf) {
        int pos = 0;
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            Preconditions.checkNotNull((Object)this.cols[c].array());
            System.arraycopy(this.cols[c].array(), this.cols[c].offset(), buf.array(), buf.offset() + pos, this.cols[c].length());
            pos += this.cols[c].length();
        }
        buf.setLength(pos);
    }

    public void exportColumns(ImmutableBitSet selectedCols, ByteArray buf, byte defaultValue) {
        int pos = 0;
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            if (this.cols[c].array() != null) {
                System.arraycopy(this.cols[c].array(), this.cols[c].offset(), buf.array(), buf.offset() + pos, this.cols[c].length());
                pos += this.cols[c].length();
                continue;
            }
            int maxLength = this.info.codeSystem.maxCodeLength(c);
            Arrays.fill(buf.array(), buf.offset() + pos, buf.offset() + pos + maxLength, defaultValue);
            pos += maxLength;
        }
        buf.setLength(pos);
    }

    public void exportColumns(ImmutableBitSet selectedCols, ByteBuffer buf) {
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            buf.put(this.cols[c].array(), this.cols[c].offset(), this.cols[c].length());
        }
    }

    public void exportColumns(int[] fieldIndex, ByteBuffer buf) {
        for (int i : fieldIndex) {
            buf.put(this.cols[i].array(), this.cols[i].offset(), this.cols[i].length());
        }
    }

    public void exportColumnBlock(int c, ByteBuffer buf) {
        this.exportColumns(this.info.colBlocks[c], buf);
    }

    public void loadCellBlock(int c, ByteBuffer buf) {
        this.loadColumns(this.info.colBlocks[c], buf);
    }

    public void loadColumns(ImmutableBitSet selectedCols, ByteBuffer buf) {
        int pos = buf.position();
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            int len = this.info.codeSystem.codeLength(c, buf);
            this.cols[c].set(buf.array(), buf.arrayOffset() + pos, len);
            buf.position(pos += len);
        }
    }

    public void loadColumns(List<Integer> selectedCols, ByteBuffer buf) {
        int pos = buf.position();
        for (int i = 0; i < selectedCols.size(); ++i) {
            int c = selectedCols.get(i);
            int len = this.info.codeSystem.codeLength(c, buf);
            this.cols[c].set(buf.array(), buf.arrayOffset() + pos, len);
            buf.position(pos += len);
        }
    }
}

