/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import com.google.common.collect.Maps;
import it.uniroma3.mat.extendedset.intset.ConciseSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import java.util.Comparator;
import java.util.NavigableMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.gridtable.IGTComparator;

public class GTInvertedIndexOfColumn {
    private final IGTComparator comparator;
    private final ReentrantReadWriteLock rwLock;
    private int nBlocks;
    private NavigableMap<ByteArray, ConciseSet> rangeIndex;
    private ConciseSet nullIndex;

    public GTInvertedIndexOfColumn(IGTComparator comparator) {
        this.comparator = comparator;
        this.rwLock = new ReentrantReadWriteLock();
        this.rangeIndex = Maps.newTreeMap((Comparator)comparator);
        this.nullIndex = new ConciseSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Iterable<ByteArray> codes, int blockId) {
        this.rwLock.writeLock().lock();
        try {
            for (ByteArray code : codes) {
                if (this.comparator.isNull(code)) {
                    this.nullIndex.add(blockId);
                    continue;
                }
                ConciseSet set = (ConciseSet)this.rangeIndex.get(code);
                if (set == null) {
                    set = new ConciseSet();
                    this.rangeIndex.put(code.copy(), set);
                }
                set.add(blockId);
            }
            if (blockId >= this.nBlocks) {
                this.nBlocks = blockId + 1;
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConciseSet getNull() {
        this.rwLock.readLock().lock();
        try {
            ConciseSet conciseSet = this.nullIndex.clone();
            return conciseSet;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConciseSet getEquals(ByteArray code) {
        this.rwLock.readLock().lock();
        try {
            ConciseSet set = (ConciseSet)this.rangeIndex.get(code);
            if (set == null) {
                ConciseSet conciseSet = new ConciseSet();
                return conciseSet;
            }
            ConciseSet conciseSet = set.clone();
            return conciseSet;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConciseSet getIn(Iterable<ByteArray> codes) {
        this.rwLock.readLock().lock();
        try {
            ConciseSet r = new ConciseSet();
            for (ByteArray code : codes) {
                ConciseSet set = (ConciseSet)this.rangeIndex.get(code);
                if (set == null) continue;
                r.addAll((IntSet)set);
            }
            ConciseSet conciseSet = r;
            return conciseSet;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConciseSet getRange(ByteArray from, boolean fromInclusive, ByteArray to, boolean toInclusive) {
        this.rwLock.readLock().lock();
        try {
            ConciseSet r = new ConciseSet();
            if (from == null && to == null) {
                r.add(this.nBlocks);
                r.complement();
                ConciseSet conciseSet = r;
                return conciseSet;
            }
            NavigableMap<ByteArray, ConciseSet> subMap = from == null ? this.rangeIndex.headMap(to, toInclusive) : (to == null ? this.rangeIndex.tailMap(from, fromInclusive) : this.rangeIndex.subMap(from, fromInclusive, to, toInclusive));
            for (ConciseSet set : subMap.values()) {
                r.addAll((IntSet)set);
            }
            ConciseSet conciseSet = r;
            return conciseSet;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }
}

