/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import it.uniroma3.mat.extendedset.intset.ConciseSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTInvertedIndexOfColumn;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTRowBlock;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;

public class GTInvertedIndex {
    private final GTInfo info;
    private final ImmutableBitSet colPreferIndex;
    private final ImmutableBitSet colBlocks;
    private final GTInvertedIndexOfColumn[] index;
    private volatile int nIndexedBlocks;

    public GTInvertedIndex(GTInfo info) {
        this.info = info;
        this.colPreferIndex = info.colPreferIndex;
        this.colBlocks = info.selectColumnBlocks(this.colPreferIndex);
        this.index = new GTInvertedIndexOfColumn[info.getColumnCount()];
        for (int i = 0; i < this.colPreferIndex.trueBitCount(); ++i) {
            int c = this.colPreferIndex.trueBitAt(i);
            this.index[c] = new GTInvertedIndexOfColumn(info.codeSystem.getComparator());
        }
    }

    public void add(GTRowBlock block) {
        int c;
        int i;
        Set[] distinctValues = new Set[this.info.getColumnCount()];
        for (int i2 = 0; i2 < this.colPreferIndex.trueBitCount(); ++i2) {
            int c2 = this.colPreferIndex.trueBitAt(i2);
            distinctValues[c2] = new HashSet();
        }
        GTRowBlock.Reader reader = block.getReader(this.colBlocks);
        GTRecord record = new GTRecord(this.info);
        while (reader.hasNext()) {
            reader.fetchNext(record);
            for (i = 0; i < this.colPreferIndex.trueBitCount(); ++i) {
                c = this.colPreferIndex.trueBitAt(i);
                distinctValues[c].add(record.get(c));
            }
        }
        for (i = 0; i < this.colPreferIndex.trueBitCount(); ++i) {
            c = this.colPreferIndex.trueBitAt(i);
            this.index[c].add(distinctValues[c], block.getSequenceId());
        }
        this.nIndexedBlocks = Math.max(this.nIndexedBlocks, block.seqId + 1);
    }

    public ConciseSet filter(TupleFilter filter) {
        return this.filter(filter, this.nIndexedBlocks);
    }

    public ConciseSet filter(TupleFilter filter, int totalBlocks) {
        int indexedBlocks = this.nIndexedBlocks;
        Evaluator evaluator = new Evaluator(indexedBlocks);
        ConciseSet r = evaluator.evaluate(filter);
        for (int i = indexedBlocks; i < totalBlocks; ++i) {
            r.add(i);
        }
        return r;
    }

    private class Evaluator {
        private int indexedBlocks;

        Evaluator(int indexedBlocks) {
            this.indexedBlocks = indexedBlocks;
        }

        public ConciseSet evaluate(TupleFilter filter) {
            if (filter == null) {
                return this.all();
            }
            if (filter instanceof LogicalTupleFilter) {
                return this.evalLogical((LogicalTupleFilter)filter);
            }
            if (filter instanceof CompareTupleFilter) {
                return this.evalCompare((CompareTupleFilter)filter);
            }
            return this.all();
        }

        private ConciseSet evalCompare(CompareTupleFilter filter) {
            int col = this.col(filter);
            if (GTInvertedIndex.this.index[col] == null) {
                return this.all();
            }
            switch (filter.getOperator()) {
                case ISNULL: {
                    return GTInvertedIndex.this.index[col].getNull();
                }
                case ISNOTNULL: {
                    return this.all();
                }
                case EQ: {
                    return GTInvertedIndex.this.index[col].getEquals((ByteArray)filter.getFirstValue());
                }
                case NEQ: {
                    return this.all();
                }
                case IN: {
                    return GTInvertedIndex.this.index[col].getIn(filter.getValues());
                }
                case NOTIN: {
                    return this.all();
                }
                case LT: {
                    return GTInvertedIndex.this.index[col].getRange(null, false, (ByteArray)filter.getFirstValue(), false);
                }
                case LTE: {
                    return GTInvertedIndex.this.index[col].getRange(null, false, (ByteArray)filter.getFirstValue(), true);
                }
                case GT: {
                    return GTInvertedIndex.this.index[col].getRange((ByteArray)filter.getFirstValue(), false, null, false);
                }
                case GTE: {
                    return GTInvertedIndex.this.index[col].getRange((ByteArray)filter.getFirstValue(), true, null, false);
                }
            }
            throw new IllegalStateException("Unsupported operator " + (Object)((Object)filter.getOperator()));
        }

        private ConciseSet evalLogical(LogicalTupleFilter filter) {
            List<? extends TupleFilter> children = filter.getChildren();
            switch (filter.getOperator()) {
                case AND: {
                    return this.evalLogicalAnd(children);
                }
                case OR: {
                    return this.evalLogicalOr(children);
                }
                case NOT: {
                    return this.evalLogicalNot(children);
                }
            }
            throw new IllegalStateException("Unsupported operator " + (Object)((Object)filter.getOperator()));
        }

        private ConciseSet evalLogicalAnd(List<? extends TupleFilter> children) {
            ConciseSet set = this.all();
            for (TupleFilter tupleFilter : children) {
                ConciseSet t = this.evaluate(tupleFilter);
                if (t == null) continue;
                set.retainAll((IntSet)t);
            }
            return set;
        }

        private ConciseSet evalLogicalOr(List<? extends TupleFilter> children) {
            ConciseSet set = new ConciseSet();
            for (TupleFilter tupleFilter : children) {
                ConciseSet t = this.evaluate(tupleFilter);
                if (t == null) {
                    return null;
                }
                set.addAll((IntSet)t);
            }
            return set;
        }

        private ConciseSet evalLogicalNot(List<? extends TupleFilter> children) {
            return this.all();
        }

        private ConciseSet all() {
            return this.not(new ConciseSet());
        }

        private ConciseSet not(ConciseSet set) {
            set.add(this.indexedBlocks);
            set.complement();
            return set;
        }

        private int col(CompareTupleFilter filter) {
            return filter.getColumn().getColumnDesc().getZeroBasedIndex();
        }
    }
}

