/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.streaming.diagnose;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class StreamingLogAnalyzer {
    public static void main(String[] args) {
        int errorFileCount = 0;
        ArrayList ellapsedTimes = Lists.newArrayList();
        String patternStr = "(\\d{2}/\\d{2}/\\d{2} \\d{2}:\\d{2}:\\d{2})";
        Pattern pattern = Pattern.compile(patternStr);
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Usage: StreamingLogsAnalyser streaming_logs_folder");
        for (File file : FileUtils.listFiles((File)new File(args[0]), (String[])new String[]{"log"}, (boolean)false)) {
            System.out.println("Processing file " + file.toString());
            long startTime = 0L;
            long endTime = 0L;
            try {
                Matcher m;
                int i;
                List<String> contents = Files.readAllLines(file.toPath(), Charset.defaultCharset());
                for (i = 0; i < contents.size(); ++i) {
                    m = pattern.matcher(contents.get(i));
                    if (!m.find()) continue;
                    startTime = format.parse("20" + m.group(1)).getTime();
                    break;
                }
                for (i = contents.size() - 1; i >= 0; --i) {
                    m = pattern.matcher(contents.get(i));
                    if (!m.find()) continue;
                    endTime = format.parse("20" + m.group(1)).getTime();
                    break;
                }
                if (startTime == 0L || endTime == 0L) {
                    throw new RuntimeException("start time or end time is not found");
                }
                if (endTime - startTime < 60000L) {
                    System.out.println("Warning: this job took less than one minute!!!! " + file.toString());
                }
                ellapsedTimes.add(endTime - startTime);
            }
            catch (Exception e) {
                System.out.println("Exception when processing log file " + file.toString());
                System.out.println(e);
                ++errorFileCount;
            }
        }
        System.out.println("Totally error files count " + errorFileCount);
        System.out.println("Totally normal files processed " + ellapsedTimes.size());
        long sum = 0L;
        for (Long x : ellapsedTimes) {
            sum += x.longValue();
        }
        System.out.println("Avg build time " + sum / (long)ellapsedTimes.size());
    }
}

