/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.streaming.cli;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.engine.streaming.BootstrapConfig;
import org.apache.kylin.engine.streaming.OneOffStreamingBuilder;
import org.apache.kylin.engine.streaming.monitor.StreamingMonitor;
import org.apache.kylin.metadata.realization.RealizationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingCLI {
    private static final Logger logger = LoggerFactory.getLogger(StreamingCLI.class);

    public static void main(String[] args) {
        try {
            Preconditions.checkArgument((boolean)args[0].equals("streaming"));
            Preconditions.checkArgument((boolean)args[1].equals("start"));
            BootstrapConfig bootstrapConfig = new BootstrapConfig();
            block16: for (int i = 2; i < args.length; ++i) {
                String argName;
                switch (argName = args[i]) {
                    case "-start": {
                        bootstrapConfig.setStart(Long.parseLong(args[++i]));
                        continue block16;
                    }
                    case "-end": {
                        bootstrapConfig.setEnd(Long.parseLong(args[++i]));
                        continue block16;
                    }
                    case "-cube": {
                        bootstrapConfig.setCubeName(args[++i]);
                        continue block16;
                    }
                    case "-fillGap": {
                        bootstrapConfig.setFillGap(Boolean.parseBoolean(args[++i]));
                        continue block16;
                    }
                    case "-maxFillGapRange": {
                        bootstrapConfig.setMaxFillGapRange(Long.parseLong(args[++i]));
                        continue block16;
                    }
                    default: {
                        logger.warn("ignore this arg:" + argName);
                    }
                }
            }
            if (bootstrapConfig.isFillGap()) {
                List<Pair<Long, Long>> gaps = StreamingMonitor.findGaps(bootstrapConfig.getCubeName());
                logger.info("all gaps:" + StringUtils.join(gaps, (String)","));
                for (Pair<Long, Long> gap : gaps) {
                    List<Pair<Long, Long>> splitGaps = StreamingCLI.splitGap(gap, bootstrapConfig.getMaxFillGapRange());
                    for (Pair<Long, Long> splitGap : splitGaps) {
                        logger.info("start filling the gap from " + splitGap.getFirst() + " to " + splitGap.getSecond());
                        StreamingCLI.startOneOffCubeStreaming(bootstrapConfig.getCubeName(), splitGap.getFirst(), splitGap.getSecond());
                        logger.info("finish filling the gap from " + splitGap.getFirst() + " to " + splitGap.getSecond());
                    }
                }
            } else {
                StreamingCLI.startOneOffCubeStreaming(bootstrapConfig.getCubeName(), bootstrapConfig.getStart(), bootstrapConfig.getEnd());
                logger.info("streaming process finished, exit with 0");
                System.exit(0);
            }
        }
        catch (Exception e) {
            StreamingCLI.printArgsError(args);
            logger.error("error start streaming", (Throwable)e);
            System.exit(-1);
        }
    }

    private static List<Pair<Long, Long>> splitGap(Pair<Long, Long> gap, long maxFillGapRange) {
        ArrayList gaps = Lists.newArrayList();
        Long startTime = gap.getFirst();
        while (startTime < gap.getSecond()) {
            Long endTime = gap.getSecond() <= startTime + maxFillGapRange ? gap.getSecond() : startTime + maxFillGapRange;
            gaps.add(Pair.newPair(startTime, endTime));
            startTime = endTime;
        }
        return gaps;
    }

    private static void startOneOffCubeStreaming(String cubeName, long start, long end) {
        Runnable runnable = new OneOffStreamingBuilder(RealizationType.CUBE, cubeName, start, end).build();
        runnable.run();
    }

    private static void printArgsError(String[] args) {
        logger.warn("invalid args:" + StringUtils.join((Object[])args, (String)" "));
    }
}

