/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.streaming.cli;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.engine.streaming.monitor.StreamingMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorCLI {
    private static final Logger logger = LoggerFactory.getLogger(MonitorCLI.class);

    public static void main(String[] args) {
        Preconditions.checkArgument((boolean)args[0].equals("monitor"));
        List receivers = null;
        String host = null;
        String tableName = null;
        String authorization = null;
        String cubeName = null;
        String projectName = "default";
        block16: for (int i = 1; i < args.length; ++i) {
            String argName;
            switch (argName = args[i]) {
                case "-receivers": {
                    receivers = Lists.newArrayList((Object[])StringUtils.split((String)args[++i], (String)";"));
                    continue block16;
                }
                case "-host": {
                    host = args[++i];
                    continue block16;
                }
                case "-tableName": {
                    tableName = args[++i];
                    continue block16;
                }
                case "-authorization": {
                    authorization = args[++i];
                    continue block16;
                }
                case "-cubeName": {
                    cubeName = args[++i];
                    continue block16;
                }
                case "-projectName": {
                    projectName = args[++i];
                    continue block16;
                }
                default: {
                    throw new RuntimeException("invalid argName:" + argName);
                }
            }
        }
        Preconditions.checkArgument((receivers != null && receivers.size() > 0 ? 1 : 0) != 0);
        StreamingMonitor streamingMonitor = new StreamingMonitor();
        if (tableName != null) {
            logger.info(String.format("check query tableName:%s host:%s receivers:%s", tableName, host, StringUtils.join((Iterable)receivers, (String)";")));
            Preconditions.checkNotNull((Object)host);
            Preconditions.checkNotNull((Object)authorization);
            Preconditions.checkNotNull((Object)tableName);
            streamingMonitor.checkCountAll(receivers, host, authorization, projectName, tableName);
        }
        if (cubeName != null) {
            logger.info(String.format("check cube cubeName:%s receivers:%s", cubeName, StringUtils.join((Iterable)receivers, (String)";")));
            streamingMonitor.checkCube(receivers, cubeName, host);
        }
        System.exit(0);
    }
}

