/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.streaming;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.kylin.common.util.StreamingBatch;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.engine.streaming.IStreamingInput;
import org.apache.kylin.engine.streaming.IStreamingOutput;
import org.apache.kylin.engine.streaming.StreamingBatchBuilder;
import org.apache.kylin.engine.streaming.util.StreamingUtils;
import org.apache.kylin.measure.hllc.HyperLogLogPlusCounter;
import org.apache.kylin.metadata.model.IBuildable;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.RealizationType;

public class OneOffStreamingBuilder {
    private final IStreamingInput streamingInput;
    private final IStreamingOutput streamingOutput;
    private final StreamingBatchBuilder streamingBatchBuilder;
    private final long startTime;
    private final long endTime;
    private final RealizationType realizationType;
    private final String realizationName;

    public OneOffStreamingBuilder(RealizationType realizationType, String realizationName, long startTime, long endTime) {
        Preconditions.checkArgument((startTime < endTime ? 1 : 0) != 0);
        this.startTime = startTime;
        this.endTime = endTime;
        this.realizationType = (RealizationType)((Object)Preconditions.checkNotNull((Object)((Object)realizationType)));
        this.realizationName = (String)Preconditions.checkNotNull((Object)realizationName);
        this.streamingInput = (IStreamingInput)Preconditions.checkNotNull((Object)StreamingUtils.getStreamingInput());
        this.streamingOutput = (IStreamingOutput)Preconditions.checkNotNull((Object)StreamingUtils.getStreamingOutput());
        this.streamingBatchBuilder = (StreamingBatchBuilder)Preconditions.checkNotNull((Object)StreamingUtils.getMicroBatchBuilder(realizationType, realizationName));
    }

    public Runnable build() {
        return new Runnable(){

            @Override
            public void run() {
                StreamingBatch streamingBatch = OneOffStreamingBuilder.this.streamingInput.getBatchWithTimeWindow(OneOffStreamingBuilder.this.realizationType, OneOffStreamingBuilder.this.realizationName, -1, OneOffStreamingBuilder.this.startTime, OneOffStreamingBuilder.this.endTime);
                IBuildable buildable = OneOffStreamingBuilder.this.streamingBatchBuilder.createBuildable(streamingBatch);
                Map<Long, HyperLogLogPlusCounter> samplingResult = OneOffStreamingBuilder.this.streamingBatchBuilder.sampling(streamingBatch);
                Map<TblColRef, Dictionary<String>> dictionaryMap = OneOffStreamingBuilder.this.streamingBatchBuilder.buildDictionary(streamingBatch, buildable);
                OneOffStreamingBuilder.this.streamingBatchBuilder.build(streamingBatch, dictionaryMap, OneOffStreamingBuilder.this.streamingOutput.getCuboidWriter(buildable));
                OneOffStreamingBuilder.this.streamingOutput.output(buildable, samplingResult);
                OneOffStreamingBuilder.this.streamingBatchBuilder.commit(buildable);
            }
        };
    }
}

