/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.RowKeyDistributionCheckerMapper;
import org.apache.kylin.engine.mr.steps.RowKeyDistributionCheckerReducer;

public class RowKeyDistributionCheckerJob
extends AbstractHadoopJob {
    protected static final Option rowKeyStatsFilePath;

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_JOB_NAME);
            options.addOption(rowKeyStatsFilePath);
            this.parseOptions(options, args);
            String statsFilePath = this.getOptionValue(rowKeyStatsFilePath);
            String jobName = this.getOptionValue(OPTION_JOB_NAME);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)jobName);
            this.setJobClasspath(this.job);
            RowKeyDistributionCheckerJob.addInputDirs(this.getOptionValue(OPTION_INPUT_PATH), this.job);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            this.job.setInputFormatClass(SequenceFileInputFormat.class);
            this.job.setMapperClass(RowKeyDistributionCheckerMapper.class);
            this.job.setMapOutputKeyClass(Text.class);
            this.job.setMapOutputValueClass(LongWritable.class);
            this.job.setReducerClass(RowKeyDistributionCheckerReducer.class);
            this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(LongWritable.class);
            this.job.setNumReduceTasks(1);
            this.job.getConfiguration().set("rowKeyStatsFilePath", statsFilePath);
            this.deletePath(this.job.getConfiguration(), output);
            return this.waitForCompletion(this.job);
        }
        catch (Exception e) {
            this.printUsage(options);
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new RowKeyDistributionCheckerJob(), (String[])args);
        System.exit(exitCode);
    }

    static {
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"rowKeyStatsFilePath");
        rowKeyStatsFilePath = OptionBuilder.create((String)"rowKeyStatsFilePath");
    }
}

