/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.SplittedBytes;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.kv.RowKeyEncoder;
import org.apache.kylin.cube.kv.RowKeyEncoderProvider;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NDCuboidMapper
extends KylinMapper<Text, Text, Text, Text> {
    private static final Logger logger = LoggerFactory.getLogger(NDCuboidMapper.class);
    private Text outputKey = new Text();
    private String cubeName;
    private String segmentName;
    private CubeSegment cubeSegment;
    private CubeDesc cubeDesc;
    private CuboidScheduler cuboidScheduler;
    private int handleCounter;
    private int skipCounter;
    private byte[] newKeyBodyBuf = new byte[16640];
    private ByteArray newKeyBuf = ByteArray.allocate(16640);
    private RowKeySplitter rowKeySplitter;
    private RowKeyEncoderProvider rowKeyEncoderProvider;

    protected void setup(Mapper.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        this.cubeName = context.getConfiguration().get("cube.name").toUpperCase();
        this.segmentName = context.getConfiguration().get("cube.segment.name").toUpperCase();
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        CubeInstance cube = CubeManager.getInstance(config).getCube(this.cubeName);
        this.cubeSegment = cube.getSegment(this.segmentName, SegmentStatusEnum.NEW);
        this.cubeDesc = cube.getDescriptor();
        this.cuboidScheduler = new CuboidScheduler(this.cubeDesc);
        this.rowKeySplitter = new RowKeySplitter(this.cubeSegment, 65, 256);
        this.rowKeyEncoderProvider = new RowKeyEncoderProvider(this.cubeSegment);
    }

    private int buildKey(Cuboid parentCuboid, Cuboid childCuboid, SplittedBytes[] splitBuffers) {
        RowKeyEncoder rowkeyEncoder = this.rowKeyEncoderProvider.getRowkeyEncoder(childCuboid);
        int offset = 0;
        long mask = Long.highestOneBit(parentCuboid.getId());
        long parentCuboidId = parentCuboid.getId();
        long childCuboidId = childCuboid.getId();
        long parentCuboidIdActualLength = 64 - Long.numberOfLeadingZeros(parentCuboid.getId());
        int index = this.rowKeySplitter.getBodySplitOffset();
        int i = 0;
        while ((long)i < parentCuboidIdActualLength) {
            if ((mask & parentCuboidId) > 0L) {
                if ((mask & childCuboidId) > 0L) {
                    System.arraycopy(splitBuffers[index].value, 0, this.newKeyBodyBuf, offset, splitBuffers[index].length);
                    offset += splitBuffers[index].length;
                }
                ++index;
            }
            mask >>= 1;
            ++i;
        }
        int fullKeySize = rowkeyEncoder.getBytesLength();
        while (this.newKeyBuf.array().length < fullKeySize) {
            this.newKeyBuf.set(new byte[this.newKeyBuf.length() * 2]);
        }
        this.newKeyBuf.set(0, fullKeySize);
        rowkeyEncoder.encode(new ByteArray(this.newKeyBodyBuf, 0, offset), this.newKeyBuf);
        return fullKeySize;
    }

    public void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        long cuboidId = this.rowKeySplitter.split(key.getBytes());
        Cuboid parentCuboid = Cuboid.findById(this.cubeDesc, cuboidId);
        List<Long> myChildren = this.cuboidScheduler.getSpanningCuboid(cuboidId);
        if (myChildren == null || myChildren.size() == 0) {
            context.getCounter("Cube Builder", "Skipped records").increment(1L);
            ++this.skipCounter;
            if (this.skipCounter % 100000 == 0) {
                logger.info("Skipped " + this.skipCounter + " records!");
            }
            return;
        }
        context.getCounter("Cube Builder", "Processed records").increment(1L);
        ++this.handleCounter;
        if (this.handleCounter % 100000 == 0) {
            logger.info("Handled " + this.handleCounter + " records!");
        }
        for (Long child : myChildren) {
            Cuboid childCuboid = Cuboid.findById(this.cubeDesc, child);
            int fullKeySize = this.buildKey(parentCuboid, childCuboid, this.rowKeySplitter.getSplitBuffers());
            this.outputKey.set(this.newKeyBuf.array(), 0, fullKeySize);
            context.write((Object)this.outputKey, (Object)value);
        }
    }
}

