/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutableOutputPO;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.execution.ExecutableState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCleanupJob
extends AbstractHadoopJob {
    private static final Option OPTION_DELETE;
    protected static final Logger logger;
    boolean delete = false;
    private KylinConfig config = null;
    public static final long TIME_THREADSHOLD = 172800000L;
    public static final long TIME_THREADSHOLD_FOR_JOB = 2592000000L;

    public int run(String[] args) throws Exception {
        Options options = new Options();
        logger.info("jobs args: " + Arrays.toString(args));
        try {
            options.addOption(OPTION_DELETE);
            this.parseOptions(options, args);
            logger.info("options: '" + this.getOptionsAsString() + "'");
            logger.info("delete option value: '" + this.getOptionValue(OPTION_DELETE) + "'");
            this.delete = Boolean.parseBoolean(this.getOptionValue(OPTION_DELETE));
            this.config = KylinConfig.getInstanceFromEnv();
            this.cleanup();
            return 0;
        }
        catch (Exception e) {
            this.printUsage(options);
            throw e;
        }
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    private boolean isOlderThanThreshold(long resourceTime) {
        long currentTime = System.currentTimeMillis();
        return currentTime - resourceTime > 172800000L;
    }

    public void cleanup() throws Exception {
        CubeManager cubeManager = CubeManager.getInstance(this.config);
        HashSet activeResourceList = Sets.newHashSet();
        for (CubeInstance cube : cubeManager.listAllCubes()) {
            for (CubeSegment segment : cube.getSegments()) {
                activeResourceList.addAll(segment.getSnapshotPaths());
                activeResourceList.addAll(segment.getDictionaryPaths());
                activeResourceList.add(segment.getStatisticsResourcePath());
            }
        }
        ArrayList toDeleteResource = Lists.newArrayList();
        for (String resourceRoot : new String[]{"/table_snapshot", "/cube_statistics"}) {
            NavigableSet<String> snapshotTables = this.getStore().listResources(resourceRoot);
            if (snapshotTables == null) continue;
            for (String snapshotTable : snapshotTables) {
                NavigableSet<String> snapshotNames = this.getStore().listResources(snapshotTable);
                if (snapshotNames == null) continue;
                for (String snapshot : snapshotNames) {
                    if (activeResourceList.contains(snapshot) || !this.isOlderThanThreshold(this.getStore().getResourceTimestamp(snapshot))) continue;
                    toDeleteResource.add(snapshot);
                }
            }
        }
        NavigableSet<String> dictTables = this.getStore().listResources("/dict");
        for (String table : dictTables) {
            NavigableSet<String> tableColNames = this.getStore().listResources(table);
            if (tableColNames == null) continue;
            for (String tableCol : tableColNames) {
                NavigableSet<String> dictionaries = this.getStore().listResources(tableCol);
                if (dictionaries == null) continue;
                for (String dict : dictionaries) {
                    if (activeResourceList.contains(dict) || !this.isOlderThanThreshold(this.getStore().getResourceTimestamp(dict))) continue;
                    toDeleteResource.add(dict);
                }
            }
        }
        ExecutableDao executableDao = ExecutableDao.getInstance(KylinConfig.getInstanceFromEnv());
        List<ExecutablePO> allExecutable = executableDao.getJobs();
        for (ExecutablePO executable : allExecutable) {
            long lastModified = executable.getLastModified();
            ExecutableOutputPO output = executableDao.getJobOutput(executable.getUuid());
            if (System.currentTimeMillis() - lastModified <= 2592000000L || !ExecutableState.SUCCEED.toString().equals(output.getStatus()) && !ExecutableState.DISCARDED.toString().equals(output.getStatus())) continue;
            toDeleteResource.add("/execute/" + executable.getUuid());
            toDeleteResource.add("/execute_output/" + executable.getUuid());
            for (ExecutablePO task : executable.getTasks()) {
                toDeleteResource.add("/execute/" + task.getUuid());
                toDeleteResource.add("/execute_output/" + task.getUuid());
            }
        }
        if (toDeleteResource.size() > 0) {
            logger.info("The following resources have no reference or is too old, will be cleaned from metadata store: \n");
            for (String s : toDeleteResource) {
                logger.info(s);
                if (!this.delete) continue;
                this.getStore().deleteResource(s);
            }
        } else {
            logger.info("No resource to be cleaned up from metadata store;");
        }
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new MetadataCleanupJob(), (String[])args);
        System.exit(exitCode);
    }

    static {
        OptionBuilder.withArgName((String)"delete");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Delete the unused metadata");
        OPTION_DELETE = OptionBuilder.create((String)"delete");
        logger = LoggerFactory.getLogger(MetadataCleanupJob.class);
    }
}

