/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.steps.CuboidJob;
import org.apache.kylin.engine.mr.steps.CuboidReducer;
import org.apache.kylin.engine.mr.steps.MergeCuboidMapper;

public class MergeCuboidJob
extends CuboidJob {
    @Override
    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_NAME);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            this.parseOptions(options, args);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase();
            String segmentName = this.getOptionValue(OPTION_SEGMENT_NAME).toUpperCase();
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            CubeManager cubeMgr = CubeManager.getInstance(config);
            CubeInstance cube = cubeMgr.getCube(cubeName);
            config = cube.getConfig();
            String jobName = this.getOptionValue(OPTION_JOB_NAME);
            logger.info("Starting: " + jobName);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)jobName);
            this.setJobClasspath(this.job);
            MergeCuboidJob.addInputDirs(this.getOptionValue(OPTION_INPUT_PATH), this.job);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            this.job.setInputFormatClass(SequenceFileInputFormat.class);
            this.job.setMapperClass(MergeCuboidMapper.class);
            this.job.setMapOutputKeyClass(Text.class);
            this.job.setMapOutputValueClass(Text.class);
            this.job.setReducerClass(CuboidReducer.class);
            this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.name", segmentName);
            this.attachKylinPropsAndMetadata(cube, this.job.getConfiguration());
            this.setReduceTaskNum(this.job, config, cubeName, 0);
            this.deletePath(this.job.getConfiguration(), output);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        catch (Exception e) {
            logger.error("error in MergeCuboidJob", (Throwable)e);
            this.printUsage(options);
            throw e;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }
}

