/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.steps.BaseCuboidMapperBase;

public class HiveToBaseCuboidMapper<KEYIN>
extends BaseCuboidMapperBase<KEYIN, Object> {
    private IMRInput.IMRTableInputFormat flatTableInputFormat;

    @Override
    protected void setup(Mapper.Context context) throws IOException {
        super.setup(context);
        this.flatTableInputFormat = MRUtil.getBatchCubingInputSide(this.cubeSegment).getFlatTableInputFormat();
    }

    public void map(KEYIN key, Object value, Mapper.Context context) throws IOException, InterruptedException {
        ++this.counter;
        if (this.counter % 100000 == 0) {
            logger.info("Handled " + this.counter + " records!");
        }
        try {
            String[] row = this.flatTableInputFormat.parseMapperInput(value);
            this.bytesSplitter.setBuffers(this.convertUTF8Bytes(row));
            this.outputKV(context);
        }
        catch (Exception ex) {
            this.handleErrorRecord(this.bytesSplitter, ex);
        }
    }
}

