/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsMapperBase;
import org.apache.kylin.measure.hllc.HyperLogLogPlusCounter;

public class FactDistinctHiveColumnsMapper<KEYIN>
extends FactDistinctColumnsMapperBase<KEYIN, Object> {
    protected boolean collectStatistics = false;
    protected CuboidScheduler cuboidScheduler = null;
    protected int nRowKey;
    private Integer[][] allCuboidsBitSet = null;
    private HyperLogLogPlusCounter[] allCuboidsHLL = null;
    private Long[] cuboidIds;
    private HashFunction hf = null;
    private int rowCount = 0;
    private int samplingPercentage;
    private ByteArray[] row_hashcodes = null;
    private ByteBuffer keyBuffer;
    private static final Text EMPTY_TEXT = new Text();
    public static final byte MARK_FOR_HLL = -1;

    @Override
    protected void setup(Mapper.Context context) throws IOException {
        super.setup(context);
        this.keyBuffer = ByteBuffer.allocate(4096);
        this.collectStatistics = Boolean.parseBoolean(context.getConfiguration().get("statistics.enabled"));
        if (this.collectStatistics) {
            int i;
            this.samplingPercentage = Integer.parseInt(context.getConfiguration().get("statistics.sampling.percent"));
            this.cuboidScheduler = new CuboidScheduler(this.cubeDesc);
            this.nRowKey = this.cubeDesc.getRowkey().getRowKeyColumns().length;
            ArrayList cuboidIdList = Lists.newArrayList();
            ArrayList allCuboidsBitSetList = Lists.newArrayList();
            this.addCuboidBitSet(this.baseCuboidId, allCuboidsBitSetList, cuboidIdList);
            this.allCuboidsBitSet = (Integer[][])allCuboidsBitSetList.toArray((T[])new Integer[cuboidIdList.size()][]);
            this.cuboidIds = cuboidIdList.toArray(new Long[cuboidIdList.size()]);
            this.allCuboidsHLL = new HyperLogLogPlusCounter[this.cuboidIds.length];
            for (i = 0; i < this.cuboidIds.length; ++i) {
                this.allCuboidsHLL[i] = new HyperLogLogPlusCounter(this.cubeDesc.getConfig().getCubeStatsHLLPrecision());
            }
            this.hf = Hashing.murmur3_32();
            this.row_hashcodes = new ByteArray[this.nRowKey];
            for (i = 0; i < this.nRowKey; ++i) {
                this.row_hashcodes[i] = new ByteArray();
            }
        }
    }

    private void addCuboidBitSet(long cuboidId, List<Integer[]> allCuboidsBitSet, List<Long> allCuboids) {
        allCuboids.add(cuboidId);
        Integer[] indice = new Integer[Long.bitCount(cuboidId)];
        long mask = Long.highestOneBit(this.baseCuboidId);
        int position = 0;
        for (int i = 0; i < this.nRowKey; ++i) {
            if ((mask & cuboidId) > 0L) {
                indice[position] = i;
                ++position;
            }
            mask >>= 1;
        }
        allCuboidsBitSet.add(indice);
        List<Long> children = this.cuboidScheduler.getSpanningCuboid(cuboidId);
        for (Long childId : children) {
            this.addCuboidBitSet(childId, allCuboidsBitSet, allCuboids);
        }
    }

    public void map(KEYIN key, Object record, Mapper.Context context) throws IOException, InterruptedException {
        String[] row = this.flatTableInputFormat.parseMapperInput(record);
        try {
            for (int i = 0; i < this.factDictCols.size(); ++i) {
                String fieldValue = row[this.dictionaryColumnIndex[i]];
                if (fieldValue == null) continue;
                this.keyBuffer.clear();
                this.keyBuffer.put(Bytes.toBytes(i)[3]);
                this.keyBuffer.put(Bytes.toBytes(fieldValue));
                this.outputKey.set(this.keyBuffer.array(), 0, this.keyBuffer.position());
                context.write((Object)this.outputKey, (Object)EMPTY_TEXT);
            }
        }
        catch (Exception ex) {
            this.handleErrorRecord(row, ex);
        }
        if (this.collectStatistics && this.rowCount < this.samplingPercentage) {
            this.putRowKeyToHLL(row);
        }
        if (this.rowCount++ == 100) {
            this.rowCount = 0;
        }
    }

    private void putRowKeyToHLL(String[] row) {
        int i;
        for (i = 0; i < this.nRowKey; ++i) {
            Hasher hc = this.hf.newHasher();
            String colValue = row[this.intermediateTableDesc.getRowKeyColumnIndexes()[i]];
            if (colValue != null) {
                this.row_hashcodes[i].set(hc.putString((CharSequence)colValue).hash().asBytes());
                continue;
            }
            this.row_hashcodes[i].set(hc.putInt(0).hash().asBytes());
        }
        int n = this.allCuboidsBitSet.length;
        for (i = 0; i < n; ++i) {
            Hasher hc = this.hf.newHasher();
            for (int position = 0; position < this.allCuboidsBitSet[i].length; ++position) {
                hc.putBytes(this.row_hashcodes[this.allCuboidsBitSet[i][position]].array());
            }
            this.allCuboidsHLL[i].add(hc.hash().asBytes());
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        if (this.collectStatistics) {
            ByteBuffer hllBuf = ByteBuffer.allocate(0x100000);
            for (int i = 0; i < this.cuboidIds.length; ++i) {
                HyperLogLogPlusCounter hll = this.allCuboidsHLL[i];
                this.keyBuffer.clear();
                this.keyBuffer.put((byte)-1);
                this.keyBuffer.putLong(this.cuboidIds[i]);
                this.outputKey.set(this.keyBuffer.array(), 0, this.keyBuffer.position());
                hllBuf.clear();
                hll.writeRegisters(hllBuf);
                this.outputValue.set(hllBuf.array(), 0, hllBuf.position());
                context.write((Object)this.outputKey, (Object)this.outputValue);
            }
        }
    }
}

